/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SortedListModel<E>
extends AbstractListModel<E> {
    private static final long serialVersionUID = 717773095606487505L;
    private final ListModel<E> unsortedModel;
    private final Comparator<E> comparator;
    private final List<SortedListEntry> sortedModel;
    private SortOrder sortOrder;

    public SortedListModel(ListModel<E> model, SortOrder sortOrder, Comparator<E> comp) {
        this.unsortedModel = model;
        this.unsortedModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                SortedListModel.this.unsortedIntervalAdded(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SortedListModel.this.unsortedIntervalRemoved(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                SortedListModel.this.unsortedContentsChanged(e);
            }
        });
        this.sortOrder = sortOrder;
        this.comparator = comp != null ? comp : null;
        int size = model.getSize();
        this.sortedModel = new ArrayList<SortedListEntry>(size);
        for (int x = 0; x < size; ++x) {
            SortedListEntry entry = new SortedListEntry(x);
            int insertionPoint = this.findInsertionPoint(entry);
            this.sortedModel.add(insertionPoint, entry);
        }
    }

    @Override
    public E getElementAt(int index) throws IndexOutOfBoundsException {
        int modelIndex = this.toUnsortedModelIndex(index);
        E element = this.unsortedModel.getElementAt(modelIndex);
        return element;
    }

    @Override
    public int getSize() {
        return this.sortedModel.size();
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        Collections.sort(this.sortedModel);
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    public ListModel<E> getUnsortedModel() {
        return this.unsortedModel;
    }

    public int toUnsortedModelIndex(int index) throws IndexOutOfBoundsException {
        int modelIndex = -1;
        SortedListEntry entry = this.sortedModel.get(index);
        modelIndex = entry.getIndex();
        return modelIndex;
    }

    private int findInsertionPoint(SortedListEntry entry) {
        int insertionPoint = this.sortedModel.size();
        if (this.sortOrder != SortOrder.UNORDERED && (insertionPoint = Collections.binarySearch(this.sortedModel, entry)) < 0) {
            insertionPoint = -(insertionPoint + 1);
        }
        return insertionPoint;
    }

    private void unsortedContentsChanged(ListDataEvent e) {
        Collections.sort(this.sortedModel);
        this.fireContentsChanged(0, 0, this.sortedModel.size() - 1);
    }

    private void unsortedIntervalAdded(ListDataEvent e) {
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsAdded = end - begin + 1;
        for (SortedListEntry entry : this.sortedModel) {
            int index = entry.getIndex();
            if (index < begin) continue;
            entry.setIndex(index + nElementsAdded);
        }
        for (int x = begin; x <= end; ++x) {
            SortedListEntry newentry = new SortedListEntry(x);
            int insertionpoint = this.findInsertionPoint(newentry);
            this.sortedModel.add(insertionpoint, newentry);
            this.fireIntervalAdded(1, insertionpoint, insertionpoint);
        }
    }

    private void unsortedIntervalRemoved(ListDataEvent e) {
        int x;
        int begin = e.getIndex0();
        int end = e.getIndex1();
        int nElementsRemoved = end - begin + 1;
        int sortedSize = this.sortedModel.size();
        boolean[] bElementRemoved = new boolean[sortedSize];
        for (x = sortedSize - 1; x >= 0; --x) {
            SortedListEntry entry = this.sortedModel.get(x);
            int index = entry.getIndex();
            if (index > end) {
                entry.setIndex(index - nElementsRemoved);
                continue;
            }
            if (index < begin) continue;
            this.sortedModel.remove(x);
            bElementRemoved[x] = true;
        }
        for (x = bElementRemoved.length - 1; x >= 0; --x) {
            if (!bElementRemoved[x]) continue;
            this.fireIntervalRemoved(2, x, x);
        }
    }

    private class SortedListEntry
    implements Comparable<SortedListEntry> {
        private int index;

        public SortedListEntry(int index) {
            this.index = index;
        }

        @Override
        public int compareTo(SortedListEntry thatEntry) {
            Object thisElement = SortedListModel.this.unsortedModel.getElementAt(this.index);
            Object thatElement = SortedListModel.this.unsortedModel.getElementAt(thatEntry.getIndex());
            int comparison = SortedListModel.this.comparator.compare(thisElement, thatElement);
            if (SortedListModel.this.sortOrder == SortOrder.DESCENDING) {
                comparison = -comparison;
            }
            return comparison;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static enum SortOrder {
        UNORDERED,
        ASCENDING,
        DESCENDING;

    }
}

