/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.internal.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public final class MathUtil {
    private static final double EPSILON = 1.0E-30;

    private MathUtil() {
    }

    public static double invLinearInterp(double x, double min, double max) {
        double denom = max - min;
        return denom < 1.0E-30 && denom > -1.0E-30 ? 0.0 : (x - min) / denom;
    }

    public static double linearInterp(double f, double min, double max) {
        return min + f * (max - min);
    }

    public static double logInterp(double f, double min, double max, double b) {
        f = (min = MathUtil.symLog(min, b)) + f * ((max = MathUtil.symLog(max, b)) - min);
        return f < 0.0 ? -Math.pow(b, -f) : Math.pow(b, f);
    }

    public static double invLogInterp(double x, double min, double max, double b) {
        min = MathUtil.symLog(min, b);
        double denom = MathUtil.symLog(max, b) - min;
        return denom < 1.0E-30 && denom > -1.0E-30 ? 0.0 : (MathUtil.symLog(x, b) - min) / denom;
    }

    public static double symLog(double x, double b) {
        return x == 0.0 ? 0.0 : (x > 0.0 ? MathUtil.log(x, b) : -MathUtil.log(-x, b));
    }

    public static double log(double x, double b) {
        return Math.log(x) / Math.log(b);
    }

    public static Point2D getIntersectionPoint(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        return MathUtil.getIntersectionPoint(new Line2D.Double(p1, p2), new Line2D.Double(p3, p4));
    }

    public static Point2D getIntersectionPoint(Line2D lineA, Line2D lineB) {
        double a1x = lineA.getX1();
        double a1y = lineA.getY1();
        double a2x = lineA.getX2();
        double a2y = lineA.getY2();
        double b1x = lineB.getX1();
        double b1y = lineB.getY1();
        double b2x = lineB.getX2();
        double b2y = lineB.getY2();
        Point2D.Double p = null;
        double d = (b2y - b1y) * (a2x - a1x) - (b2x - b1x) * (a2y - a1y);
        if (d != 0.0) {
            double ua = ((b2x - b1x) * (a1y - b1y) - (b2y - b1y) * (a1x - b1x)) / d;
            double ub = ((a2x - a1x) * (a1y - b1y) - (a2y - a1y) * (a1x - b1x)) / d;
            if (0.0 <= ua && ua <= 1.0 && 0.0 <= ub && ub <= 1.0) {
                double xi = a1x + ua * (a2x - a1x);
                double yi = a1y + ua * (a2y - a1y);
                p = new Point2D.Double(xi, yi);
            }
        }
        return p;
    }

    public static Point2D[] getIntersectionPoints(Line2D line, Rectangle2D rect) {
        Point2D[] p = new Point2D[]{MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY())), MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX(), rect.getY() + rect.getHeight(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight())), MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX(), rect.getY(), rect.getX(), rect.getY() + rect.getHeight())), MathUtil.getIntersectionPoint(line, new Line2D.Double(rect.getX() + rect.getWidth(), rect.getY(), rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight()))};
        return p;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double normalizeAngle(double angle) {
        double value = angle % 360.0;
        if (angle < 0.0) {
            value += 360.0;
        }
        return value;
    }

    public static int getQuadrant(double angle) {
        return (int)(MathUtil.normalizeAngle(angle) / 90.0) % 4 + 1;
    }

    public static Line2D rotate(Line2D line, double angle, double anchorx, double anchory) {
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(angle), anchorx, anchory);
        Point2D p1 = at.transform(line.getP1(), new Point2D.Double());
        Point2D p2 = at.transform(line.getP2(), new Point2D.Double());
        return new Line2D.Double(p1, p2);
    }

    public static double scaleToFit(double w1, double h1, double w2, double h2) {
        double fw = 0.0;
        double fh = 0.0;
        if (w1 > 0.0) {
            fw = w2 / w1;
        }
        if (h1 > 0.0) {
            fh = h2 / h1;
        }
        return Math.min(fw, fh);
    }
}

