/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.work;

import org.cytoscape.ding.impl.work.DiscreteProgressMonitor;
import org.cytoscape.ding.impl.work.NoOutputProgressMonitor;
import org.cytoscape.ding.impl.work.ProgressMonitorCloseable;
import org.cytoscape.ding.impl.work.SubProgressMonitor;

public interface ProgressMonitor {
    public void cancel();

    public boolean isCancelled();

    public void addProgress(double var1);

    public void start(String var1);

    public void done();

    default public void emptyTask(String taskName) {
        this.start(taskName);
        this.done();
    }

    default public ProgressMonitorCloseable task(final String taskName) {
        return new ProgressMonitorCloseable(){
            {
                ProgressMonitor.this.start(taskName);
            }

            @Override
            public void close() {
                ProgressMonitor.this.done();
            }
        };
    }

    default public DiscreteProgressMonitor toDiscrete(int totalWork) {
        return new DiscreteProgressMonitor(this, totalWork);
    }

    public static ProgressMonitor notNull(ProgressMonitor pm) {
        return pm == null ? new NoOutputProgressMonitor() : pm;
    }

    default public ProgressMonitor[] split(double ... parts) {
        double sum = 0.0;
        for (double part : parts) {
            sum += part;
        }
        ProgressMonitor[] monitors = new ProgressMonitor[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            double percent = parts[i] / sum;
            monitors[i] = this.createSubProgressMonitor(percent);
        }
        return monitors;
    }

    default public ProgressMonitor createSubProgressMonitor(double percent) {
        return new SubProgressMonitor(this, percent);
    }
}

