/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.undo;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.ding.impl.undo.ViewChangeEdit;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;

public class ViewState {
    protected double scaleFactor;
    protected Point2D center;
    protected Map<View<CyNode>, Point2D.Double> points;
    protected Map<View<CyEdge>, List> anchors;
    protected Map<View<CyEdge>, Integer> linetype;
    protected CyNetworkViewSnapshot view;
    protected DRenderingEngine re;
    protected ViewChangeEdit.SavedObjs savedObjs;

    public ViewState(DRenderingEngine re, ViewChangeEdit.SavedObjs whatToSave) {
        double y;
        double x;
        this.view = re.getViewModelSnapshot();
        this.re = re;
        this.points = null;
        this.anchors = null;
        this.linetype = null;
        this.savedObjs = whatToSave;
        this.center = re.getTransform().getCenter();
        this.scaleFactor = re.getZoom();
        NodeDetails nodeDetails = re.getNodeDetails();
        if (whatToSave == ViewChangeEdit.SavedObjs.ALL || whatToSave == ViewChangeEdit.SavedObjs.NODES) {
            this.points = new WeakHashMap<View<CyNode>, Point2D.Double>();
            for (View n : this.view.getNodeViews()) {
                x = nodeDetails.getXPosition((View<CyNode>)n);
                y = nodeDetails.getYPosition((View<CyNode>)n);
                this.points.put((View<CyNode>)n, new Point2D.Double(x, y));
            }
        }
        if (whatToSave == ViewChangeEdit.SavedObjs.ALL || whatToSave == ViewChangeEdit.SavedObjs.EDGES) {
            this.anchors = new WeakHashMap<View<CyEdge>, List>();
            this.linetype = new WeakHashMap<View<CyEdge>, Integer>();
            for (View e : this.view.getEdgeViews()) {
                this.linetype.put((View<CyEdge>)e, re.getEdgeDetails().getLineCurved((View<CyEdge>)e));
            }
        }
        if (whatToSave == ViewChangeEdit.SavedObjs.SELECTED || whatToSave == ViewChangeEdit.SavedObjs.SELECTED_NODES) {
            this.points = new WeakHashMap<View<CyNode>, Point2D.Double>();
            for (View n : this.view.getTrackedNodes(DingNetworkViewFactory.SELECTED_NODES)) {
                x = nodeDetails.getXPosition((View<CyNode>)n);
                y = nodeDetails.getYPosition((View<CyNode>)n);
                this.points.put((View<CyNode>)n, new Point2D.Double(x, y));
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ViewState)) {
            return false;
        }
        ViewState vs = (ViewState)o;
        if (this.view != vs.view) {
            return false;
        }
        if (!this.center.equals(vs.center)) {
            return false;
        }
        if (Double.compare(this.scaleFactor, vs.scaleFactor) != 0) {
            return false;
        }
        if (this.savedObjs != vs.savedObjs) {
            return false;
        }
        if (this.points != null) {
            if (vs.points == null || this.points.size() != vs.points.size()) {
                return false;
            }
            for (View<CyNode> view : this.points.keySet()) {
                if (this.points.get(view).equals(vs.points.get(view))) continue;
                return false;
            }
        }
        if (this.anchors != null) {
            if (vs.anchors == null || this.anchors.size() != vs.anchors.size()) {
                return false;
            }
            for (View<CyNode> view : this.anchors.keySet()) {
                if (!this.anchors.get(view).equals(vs.anchors.get(view))) {
                    return false;
                }
                if (this.linetype.get(view).equals(vs.linetype.get(view))) continue;
                return false;
            }
        }
        return true;
    }

    public void apply() {
        if (this.points != null) {
            for (View<CyNode> view : this.points.keySet()) {
                Point2D.Double p = this.points.get(view);
                View mutableNode = this.view.getMutableNodeView(view.getSUID().longValue());
                if (mutableNode == null) continue;
                mutableNode.setVisualProperty(DVisualLexicon.NODE_X_LOCATION, (Object)p.getX());
                mutableNode.setVisualProperty(DVisualLexicon.NODE_Y_LOCATION, (Object)p.getY());
            }
        }
        this.re.setZoom(this.scaleFactor);
        this.re.setCenter(this.center.getX(), this.center.getY());
        this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL);
        if (this.anchors != null) {
            for (View<CyNode> view : this.anchors.keySet()) {
                View mutableEdge = this.view.getMutableEdgeView(view.getSUID().longValue());
                if (mutableEdge == null) continue;
                mutableEdge.setVisualProperty(DVisualLexicon.EDGE_CURVED, (Object)this.linetype.get(view));
            }
        }
    }
}

