/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.undo;

import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.undo.ViewState;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class ViewChangeEdit
extends AbstractCyEdit {
    private ViewState origState;
    private ViewState newState;
    private final DRenderingEngine re;
    private final SavedObjs savedObjs;
    private final CyServiceRegistrar serviceRegistrar;

    public ViewChangeEdit(DRenderingEngine re, String label, CyServiceRegistrar serviceRegistrar) {
        this(re, SavedObjs.ALL, label, serviceRegistrar);
    }

    public ViewChangeEdit(DRenderingEngine re, SavedObjs saveObjs, String label, CyServiceRegistrar serviceRegistrar) {
        super(label);
        this.re = re;
        this.savedObjs = saveObjs;
        this.serviceRegistrar = serviceRegistrar;
        this.saveOldPositions();
    }

    protected void saveOldPositions() {
        this.origState = new ViewState(this.re, this.savedObjs);
    }

    public void saveNewPositions() {
        this.newState = new ViewState(this.re, this.savedObjs);
    }

    public void post() {
        this.saveNewPositions();
        if (!this.origState.equals(this.newState)) {
            ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)this);
        }
    }

    public void redo() {
        this.newState.apply();
    }

    public void undo() {
        this.origState.apply();
    }

    public static enum SavedObjs {
        ALL,
        SELECTED,
        NODES,
        EDGES,
        SELECTED_NODES,
        SELECTED_EDGES;

    }
}

