/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.undo;

import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.LabelSelection;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.undo.AbstractCyEdit;

public class LabelEdit
extends AbstractCyEdit {
    private final CyServiceRegistrar serviceRegistrar;
    private final DRenderingEngine re;
    private final CyNetworkView netView;
    private final Long nodeId;
    private final LabelSelection labelSelection;
    private ObjectPosition startPosition;
    private Double startAngle;
    private ObjectPosition endPosition;
    private Double endAngle;

    public LabelEdit(CyServiceRegistrar serviceRegistrar, DRenderingEngine re, CyNetworkView netview, Long nodeId, LabelSelection labelSelection) {
        super("Move Label");
        this.re = re;
        this.serviceRegistrar = serviceRegistrar;
        this.netView = netview;
        this.nodeId = nodeId;
        this.labelSelection = labelSelection;
        View mutableNode = re.getViewModelSnapshot().getMutableNodeView(labelSelection.getNode().getSUID().longValue());
        if (mutableNode.isValueLocked(DVisualLexicon.NODE_LABEL_POSITION)) {
            this.startPosition = labelSelection.getPosition();
        }
        if (mutableNode.isValueLocked(DVisualLexicon.NODE_LABEL_ROTATION)) {
            this.startAngle = labelSelection.getAngleDegrees();
        }
    }

    private boolean isNetworkViewRegistered() {
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        return netViewMgr.getNetworkViews((CyNetwork)this.netView.getModel()).contains(this.netView);
    }

    private void updateView() {
        VisualStyle style = ((VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class)).getVisualStyle(this.netView);
        style.apply(this.netView);
        this.netView.updateView();
    }

    private View<CyNode> getMutableNodeView() {
        return this.re.getViewModelSnapshot().getMutableNodeView(this.labelSelection.getNode().getSUID().longValue());
    }

    public void savePositionAndAngle() {
        this.endPosition = this.labelSelection.getPosition();
        this.endAngle = this.labelSelection.getAngleDegrees();
    }

    public void undo() {
        this.re.getLabelSelectionManager().clear();
        if (this.isNetworkViewRegistered()) {
            View<CyNode> node = this.getMutableNodeView();
            if (this.startPosition == null) {
                node.clearValueLock(DVisualLexicon.NODE_LABEL_POSITION);
            } else {
                node.setLockedValue(DVisualLexicon.NODE_LABEL_POSITION, (Object)this.startPosition);
            }
            if (this.startAngle == null) {
                node.clearValueLock(DVisualLexicon.NODE_LABEL_ROTATION);
            } else {
                node.setLockedValue(DVisualLexicon.NODE_LABEL_ROTATION, (Object)this.startAngle);
            }
            this.updateView();
        }
    }

    public void redo() {
        this.re.getLabelSelectionManager().clear();
        if (this.isNetworkViewRegistered()) {
            View<CyNode> node = this.getMutableNodeView();
            node.setLockedValue(DVisualLexicon.NODE_LABEL_POSITION, (Object)this.endPosition);
            node.setLockedValue(DVisualLexicon.NODE_LABEL_ROTATION, (Object)this.endAngle);
            this.updateView();
        }
    }
}

