/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.undo;

import java.util.Collections;
import org.cytoscape.ding.impl.AddEdgeTask;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class AddEdgeEdit
extends AbstractCyEdit {
    private final CyServiceRegistrar registrar;
    private final CyNetworkViewSnapshot snapshot;
    private final View<CyNode> sourceNodeView;
    private final View<CyNode> targetNodeView;
    private CyEdge edge;

    public AddEdgeEdit(CyServiceRegistrar registrar, CyNetworkViewSnapshot snapshot, View<CyNode> sourceNodeView, View<CyNode> targetNodeView, View<CyEdge> edgeView) {
        super("Add Edge");
        this.registrar = registrar;
        this.snapshot = snapshot;
        this.sourceNodeView = sourceNodeView;
        this.targetNodeView = targetNodeView;
        this.edge = (CyEdge)edgeView.getModel();
    }

    public void undo() {
        CyNetwork network = (CyNetwork)this.snapshot.getMutableNetworkView().getModel();
        network.removeEdges(Collections.singleton(this.edge));
    }

    public void redo() {
        AddEdgeTask addEdgeTask = new AddEdgeTask(this.registrar, this.snapshot, this.sourceNodeView, this.targetNodeView);
        addEdgeTask.setPostUndo(false);
        DialogTaskManager taskManager = (DialogTaskManager)this.registrar.getService(DialogTaskManager.class);
        taskManager.execute(new TaskIterator(new Task[]{addEdgeTask}), new TaskObserver(){

            public void taskFinished(ObservableTask task) {
                if (task instanceof AddEdgeTask) {
                    AddEdgeEdit.this.edge = ((AddEdgeTask)task).getResults(CyEdge.class);
                }
            }

            public void allFinished(FinishStatus finishStatus) {
            }
        });
    }

    public void post() {
        ((UndoSupport)this.registrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)this);
    }
}

