/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.strokes;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.cytoscape.ding.impl.strokes.ShapeStroke;
import org.cytoscape.ding.impl.strokes.WidthStroke;

public class ContiguousArrowStroke
extends ShapeStroke {
    public ContiguousArrowStroke(float width) {
        super(new Shape[]{ContiguousArrowStroke.getArrowStroke(width)}, 3.0f * width, width);
    }

    @Override
    public WidthStroke newInstanceForWidth(float w) {
        return new ContiguousArrowStroke(w);
    }

    private static Shape getArrowStroke(float width) {
        GeneralPath shape = new GeneralPath();
        float length = 3.0f * width;
        float lineWidth = width;
        float arrowWidth = 4.0f * width;
        float arrowArmBreadthFactor = 0.5f;
        float begin = 0.0f;
        float halfLineWidth = 0.5f * lineWidth;
        float halfArrowWidth = 0.5f * arrowWidth;
        float arrowArmBreadth = arrowArmBreadthFactor * lineWidth;
        float arrowArmStart = length / 2.0f - arrowArmBreadth / 2.0f;
        float arrowArmEnd = length / 2.0f + arrowArmBreadth / 2.0f;
        shape.moveTo(begin, halfLineWidth);
        shape.lineTo(arrowArmStart, halfLineWidth);
        shape.lineTo(begin, halfArrowWidth);
        shape.lineTo(arrowArmBreadth, halfArrowWidth);
        shape.lineTo(arrowArmEnd, halfLineWidth);
        shape.lineTo(length, halfLineWidth);
        shape.lineTo(length, -halfLineWidth);
        shape.lineTo(arrowArmEnd, -halfLineWidth);
        shape.lineTo(arrowArmBreadth, -halfArrowWidth);
        shape.lineTo(begin, -halfArrowWidth);
        shape.lineTo(arrowArmStart, -halfLineWidth);
        shape.lineTo(begin, -halfLineWidth);
        shape.lineTo(begin, halfLineWidth);
        return shape;
    }
}

