/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.BendImpl;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.ding.impl.editor.SimpleRootPaneContainer;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.SavePolicy;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.presentation.property.values.Bend;

public class EdgeBendValueEditorDialog {
    private static final Dimension DEF_PANEL_SIZE = new Dimension(600, 400);
    private JDialog dialog;
    private SimpleRootPaneContainer innerPanel;
    private CyNetworkView dummyView;
    private View<CyEdge> edgeView;
    private final DingNetworkViewFactory cyNetworkViewFactory;
    private final RenderingEngineFactory<CyNetwork> presentationFactory;
    private final CyServiceRegistrar serviceRegistrar;
    private boolean editCancelled;
    private boolean bendRemoved;

    public EdgeBendValueEditorDialog(DingNetworkViewFactory cyNetworkViewFactory, RenderingEngineFactory<CyNetwork> presentationFactory, CyServiceRegistrar serviceRegistrar) {
        this.cyNetworkViewFactory = Objects.requireNonNull(cyNetworkViewFactory, "CyNetworkViewFactory is null.");
        this.presentationFactory = Objects.requireNonNull(presentationFactory, "RenderingEngineFactory is null.");
        this.serviceRegistrar = serviceRegistrar;
    }

    private void init(Component parent) {
        Window owner = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        this.dialog = new JDialog(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setTitle("Edge Bend Editor");
        this.dialog.setResizable(false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EdgeBendValueEditorDialog.this.editCancelled = true;
            }
        });
        this.dialog.setPreferredSize(DEF_PANEL_SIZE);
        String newHandleAction = this.getHandleActionLabel();
        JLabel infoLabel = new JLabel("<html><b>1. <i>" + newHandleAction + "</i></b> the edge to add a new handle.<br /><b>2. </b>Drag handles to bend (select the edge first).</html>");
        infoLabel.setFont(infoLabel.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        this.innerPanel = new SimpleRootPaneContainer();
        this.innerPanel.setBackground(UIManager.getColor("Table.background"));
        this.innerPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
        JButton okButton = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeBendValueEditorDialog.this.editCancelled = false;
                EdgeBendValueEditorDialog.this.dialog.dispose();
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeBendValueEditorDialog.this.editCancelled = true;
                EdgeBendValueEditorDialog.this.dialog.dispose();
            }
        });
        JButton removeBendButton = new JButton(new AbstractAction("Remove Bend"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdgeBendValueEditorDialog.this.bendRemoved = true;
                EdgeBendValueEditorDialog.this.editCancelled = false;
                EdgeBendValueEditorDialog.this.dialog.dispose();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)okButton, (JButton)cancelButton, (JComponent[])new JComponent[]{removeBendButton});
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.dialog.getRootPane(), (Action)okButton.getAction(), (Action)cancelButton.getAction());
        this.dialog.getRootPane().setDefaultButton(okButton);
        GroupLayout layout = new GroupLayout(this.dialog.getContentPane());
        this.dialog.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(infoLabel).addComponent(this.innerPanel).addComponent(buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(infoLabel).addComponent(this.innerPanel).addComponent(buttonPanel));
    }

    private String getHandleActionLabel() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return "Alt-click";
        }
        if (osName.contains("mac")) {
            return "Option-click";
        }
        return "Ctrl-Alt-click";
    }

    private void updateUI(Bend startBend) {
        Color NODE_COLOR = UIManager.getColor("Label.disabledForeground");
        Color EDGE_COLOR = UIManager.getColor("Label.foreground");
        Color SELECTION_COLOR = UIManager.getColor("Focus.color");
        Color BACKGROUND_COLOR = UIManager.getColor("Table.background");
        CyNetworkFactory networkFactory = (CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class);
        CyNetwork dummyNet = networkFactory.createNetworkWithPrivateTables(SavePolicy.DO_NOT_SAVE);
        CyNode source = dummyNet.addNode();
        CyNode target = dummyNet.addNode();
        CyEdge edge = dummyNet.addEdge(source, target, true);
        this.dummyView = this.cyNetworkViewFactory.createNetworkView(dummyNet);
        View sourceView = this.dummyView.getNodeView(source);
        View targetView = this.dummyView.getNodeView(target);
        this.edgeView = this.dummyView.getEdgeView(edge);
        this.dummyView.setVisualProperty(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT, (Object)BACKGROUND_COLOR);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_FILL_COLOR, (Object)NODE_COLOR);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_FILL_COLOR, (Object)NODE_COLOR);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_LABEL_COLOR, (Object)BACKGROUND_COLOR);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_LABEL_COLOR, (Object)BACKGROUND_COLOR);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_SELECTED_PAINT, (Object)SELECTION_COLOR);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_SELECTED_PAINT, (Object)SELECTION_COLOR);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_LABEL_FONT_SIZE, (Object)16);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_LABEL_FONT_SIZE, (Object)16);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_LABEL, (Object)"S");
        targetView.setVisualProperty(BasicVisualLexicon.NODE_LABEL, (Object)"T");
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.ELLIPSE);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.ELLIPSE);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_WIDTH, (Object)40.0);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_HEIGHT, (Object)40.0);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)NODE_COLOR);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_WIDTH, (Object)40.0);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_HEIGHT, (Object)40.0);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)NODE_COLOR);
        this.edgeView.setVisualProperty(BasicVisualLexicon.EDGE_SELECTED_PAINT, (Object)SELECTION_COLOR);
        this.edgeView.setVisualProperty(BasicVisualLexicon.EDGE_STROKE_SELECTED_PAINT, (Object)SELECTION_COLOR);
        this.edgeView.setVisualProperty(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT, (Object)EDGE_COLOR);
        this.edgeView.setVisualProperty(BasicVisualLexicon.EDGE_WIDTH, (Object)4.0);
        this.edgeView.setVisualProperty(BasicVisualLexicon.EDGE_TARGET_ARROW_SHAPE, (Object)ArrowShapeVisualProperty.ARROW);
        this.edgeView.setVisualProperty(DVisualLexicon.EDGE_TARGET_ARROW_UNSELECTED_PAINT, (Object)EDGE_COLOR);
        this.edgeView.setVisualProperty(DVisualLexicon.EDGE_CURVED, (Object)true);
        if (startBend == null || startBend.equals(BasicVisualLexicon.EDGE_BEND.getDefault())) {
            startBend = new BendImpl();
        }
        this.edgeView.setVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND, (Object)startBend);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)0.0);
        sourceView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)100.0);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)400.0);
        targetView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)120.0);
        this.presentationFactory.createRenderingEngine((Object)this.innerPanel, (View)this.dummyView);
    }

    public boolean isEditCancelled() {
        return this.editCancelled;
    }

    public Bend showDialog(Component parent, Bend initialValue) {
        this.init(parent);
        this.editCancelled = false;
        this.bendRemoved = false;
        this.updateUI(initialValue);
        if (parent != null) {
            this.dialog.setLocationRelativeTo(parent);
        } else {
            this.dialog.setLocationByPlatform(true);
        }
        this.dialog.pack();
        this.dummyView.fitContent();
        this.dialog.setVisible(true);
        this.cyNetworkViewFactory.removeRenderingEngine(this.dummyView);
        this.dummyView.dispose();
        this.dialog.dispose();
        if (this.bendRemoved) {
            return (Bend)BasicVisualLexicon.EDGE_BEND.getDefault();
        }
        if (!this.editCancelled) {
            return (Bend)this.edgeView.getVisualProperty((VisualProperty)BasicVisualLexicon.EDGE_BEND);
        }
        return null;
    }
}

