/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.cytoscape.ding.icon.VisualPropertyIconFactory;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.LineType;
import org.cytoscape.view.presentation.property.values.VisualPropertyValue;
import org.cytoscape.view.vizmap.gui.DefaultViewPanel;
import org.jdesktop.swingx.JXList;

public class DiscreteValueList<T>
extends JXList {
    private int iconWidth = -1;
    private int iconHeight = -1;
    private final Class<T> type;
    private final VisualProperty<T> vp;
    private final Set<T> values;
    private final Map<T, Icon> iconMap;
    private final DefaultListModel<T> model;
    private final DefaultViewPanel defViewPanel;

    public DiscreteValueList(Class<T> type, DefaultViewPanel defViewPanel) {
        this(type, null, defViewPanel);
    }

    public DiscreteValueList(Class<T> type, int iconWidth, int iconHeight, DefaultViewPanel defViewPanel) {
        this(type, null, defViewPanel);
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
    }

    public DiscreteValueList(Class<T> type, VisualProperty<T> vp, DefaultViewPanel defViewPanel) {
        this.type = type;
        this.vp = vp;
        this.defViewPanel = defViewPanel;
        this.values = Collections.synchronizedSet(new LinkedHashSet());
        this.iconMap = new HashMap<T, Icon>();
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.setCellRenderer(new IconCellRenderer());
        this.setAutoCreateRowSorter(true);
        this.setSortOrder(SortOrder.ASCENDING);
        this.setSelectionMode(0);
        this.setCursor(new Cursor(12));
        final Collator collator = Collator.getInstance(Locale.getDefault());
        this.setComparator(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 instanceof VisualPropertyValue) {
                    return collator.compare(((VisualPropertyValue)o1).getDisplayName(), ((VisualPropertyValue)o2).getDisplayName());
                }
                if (o1 instanceof Font) {
                    return collator.compare(((Font)o1).getFontName(), ((Font)o2).getFontName());
                }
                return collator.compare(o1.toString(), o2.toString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderIcons(Set<T> values) {
        RenderingEngine engine;
        if (this.type == Font.class) {
            return;
        }
        this.iconMap.clear();
        RenderingEngine renderingEngine = engine = this.defViewPanel != null ? this.defViewPanel.getRenderingEngine() : null;
        if (engine != null) {
            Set<T> set = values;
            synchronized (set) {
                for (T val : values) {
                    Icon icon = null;
                    if (val instanceof CyCustomGraphics) {
                        icon = VisualPropertyIconFactory.createIcon(val, this.getIconWidth(), this.getIconHeight());
                    } else if (this.vp != null) {
                        icon = engine.createIcon(this.vp, val, this.getIconWidth(), this.getIconHeight());
                    }
                    if (icon == null) continue;
                    this.iconMap.put(val, icon);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListItems(Collection<T> newValues, T selectedValue) {
        Set<T> set = this.values;
        synchronized (set) {
            this.values.clear();
            if (newValues != null) {
                this.values.addAll(newValues);
            }
        }
        this.renderIcons(this.values);
        this.model.removeAllElements();
        set = this.values;
        synchronized (set) {
            for (T key : this.values) {
                this.model.addElement(key);
            }
        }
        if (selectedValue != null) {
            this.setSelectedValue(selectedValue, true);
        }
        this.repaint();
    }

    private int getIconWidth() {
        if (this.iconWidth == -1) {
            this.iconWidth = this.type == LineType.class || this.type == ArrowShape.class ? 64 : 32;
        }
        return this.iconWidth;
    }

    private int getIconHeight() {
        if (this.iconHeight == -1) {
            this.iconHeight = 32;
        }
        return this.iconHeight;
    }

    private String getLabel(T value) {
        String text = null;
        Class<?> valueClass = value.getClass();
        if (value instanceof Font) {
            text = ((Font)value).getFontName();
        } else {
            try {
                Method displayMethod = valueClass.getMethod("getDisplayName", new Class[]{null});
                Object returnVal = displayMethod.invoke(value, new Object[]{null});
                if (returnVal != null) {
                    text = returnVal.toString();
                }
            }
            catch (Exception e) {
                text = value.toString();
            }
        }
        return text;
    }

    private final class IconCellRenderer
    extends JPanel
    implements ListCellRenderer<T> {
        private final Color BG_COLOR = UIManager.getColor("Table.background");
        private final Color FG_COLOR = UIManager.getColor("Table.foreground");
        private final Color SELECTED_BG_COLOR = UIManager.getColor("Table.selectionBackground");
        private final Color SELECTED_FG_COLOR = UIManager.getColor("Table.selectionForeground");

        public IconCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.removeAll();
            this.setBackground(isSelected ? this.SELECTED_BG_COLOR : this.BG_COLOR);
            this.setForeground(isSelected ? this.SELECTED_FG_COLOR : this.FG_COLOR);
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground"));
            Border paddingBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
            this.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
            this.setLayout(new BoxLayout(this, 0));
            Icon icon = DiscreteValueList.this.iconMap.get(value);
            if (icon != null) {
                JLabel iconLbl = new JLabel(DiscreteValueList.this.iconMap.get(value));
                iconLbl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                this.add(iconLbl);
                this.add(Box.createHorizontalStrut(20));
            }
            JLabel textLbl = new JLabel(DiscreteValueList.this.getLabel(value));
            if (value instanceof Font) {
                textLbl.setFont(((Font)value).deriveFont(14.0f));
            }
            this.add(textLbl);
            this.add(Box.createHorizontalGlue());
            return this;
        }
    }
}

