/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.Collections;
import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.RemoveSelectedAnnotationsTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class RemoveSelectedAnnotationsTaskFactory
implements NetworkViewTaskFactory {
    private final DingRenderer dingRenderer;
    private final CyServiceRegistrar serviceRegistrar;

    public RemoveSelectedAnnotationsTaskFactory(DingRenderer dingRenderer, CyServiceRegistrar serviceRegistrar) {
        this.dingRenderer = dingRenderer;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyNetworkView view) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return null;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        List<Annotation> annotations = cyAnnotator != null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : Collections.EMPTY_LIST;
        return new TaskIterator(new Task[]{new RemoveSelectedAnnotationsTask(re, annotations, this.serviceRegistrar)});
    }

    public boolean isReady(CyNetworkView view) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(view);
        if (re == null) {
            return false;
        }
        CyAnnotator cyAnnotator = re.getCyAnnotator();
        List<DingAnnotation> annotations = cyAnnotator != null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : null;
        return annotations != null && !annotations.isEmpty();
    }
}

