/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.geom.Point2D;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.RemoveAnnotationCommandTask;
import org.cytoscape.ding.impl.cyannotator.tasks.RemoveAnnotationTask;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class RemoveAnnotationTaskFactory
implements NetworkViewLocationTaskFactory,
TaskFactory {
    private final DingRenderer dingRenderer;
    private final AnnotationManager annotationManager;
    private final CyNetworkViewManager viewManager;

    public RemoveAnnotationTaskFactory(DingRenderer dingRenderer) {
        this.dingRenderer = dingRenderer;
        this.annotationManager = null;
        this.viewManager = null;
    }

    public RemoveAnnotationTaskFactory(AnnotationManager annotationManager, CyNetworkViewManager viewManager) {
        this.annotationManager = annotationManager;
        this.viewManager = viewManager;
        this.dingRenderer = null;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new RemoveAnnotationCommandTask(this.annotationManager, this.viewManager)});
    }

    public boolean isReady() {
        return true;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        DingAnnotation annotation = re != null ? re.getPicker().getAnnotationAt(javaPt) : null;
        return annotation != null ? new TaskIterator(new Task[]{new RemoveAnnotationTask(re, annotation)}) : null;
    }

    public boolean isReady(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        DingAnnotation annotation = re != null ? re.getPicker().getAnnotationAt(javaPt) : null;
        return annotation != null;
    }
}

