/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.AnnotationJsonConverter;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class ListAnnotationsTask
extends AbstractTask
implements ObservableTask {
    private final AnnotationManager annotationManager;
    private List<CyNetworkView> networkViews;
    private List<Annotation> annotations;
    private CyNetworkViewManager viewManager;
    @Tunable(description="Network View", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="current", context="nogui")
    public CyNetworkView view = null;

    public ListAnnotationsTask(AnnotationManager annotationManager, CyNetworkViewManager viewManager) {
        this.annotationManager = annotationManager;
        this.viewManager = viewManager;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("List Annotations");
        if (this.view != null) {
            this.annotations = this.annotationManager.getAnnotations(this.view);
            return;
        }
        this.annotations = new ArrayList<Annotation>();
        for (CyNetworkView view : this.viewManager.getNetworkViewSet()) {
            this.annotations.addAll(this.annotationManager.getAnnotations(view));
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class, String.class);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(String.class)) {
            if (this.annotations.size() == 0) {
                return (R)"No annotations found for view";
            }
            StringBuilder sb = new StringBuilder();
            for (Annotation a : this.annotations) {
                sb.append(a.toString() + "\n");
            }
            return (R)sb.toString();
        }
        if (type.equals(JSONResult.class)) {
            if (this.annotations.size() == 0) {
                JSONResult res = () -> "[]";
                return (R)res;
            }
            JSONResult res = () -> {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                for (Annotation a : this.annotations) {
                    sb.append(AnnotationJsonConverter.toJson((DingAnnotation)a) + ",");
                }
                int len = sb.length();
                sb.replace(len - 1, len, "]");
                return sb.toString();
            };
            return (R)res;
        }
        return null;
    }
}

