/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.Point;
import java.awt.geom.Point2D;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.EditAnnotationTask;
import org.cytoscape.ding.impl.cyannotator.ui.AnnotationMediator;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class EditAnnotationTaskFactory
implements NetworkViewLocationTaskFactory {
    private final DingRenderer dingRenderer;
    private final AnnotationMediator mediator;

    public EditAnnotationTaskFactory(DingRenderer dingRenderer, AnnotationMediator mediator) {
        this.dingRenderer = dingRenderer;
        this.mediator = mediator;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        if (re == null) {
            return null;
        }
        DingAnnotation annotation = re.getPicker().getAnnotationAt(javaPt);
        Point p = new Point((int)javaPt.getX(), (int)javaPt.getY());
        return new TaskIterator(new Task[]{new EditAnnotationTask(annotation, this.mediator, p)});
    }

    public TaskIterator createTaskIterator(DingAnnotation annotation, CyNetworkView networkView, Point2D javaPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        if (re == null) {
            return null;
        }
        Point p = javaPt != null ? new Point((int)javaPt.getX(), (int)javaPt.getY()) : null;
        return new TaskIterator(new Task[]{new EditAnnotationTask(annotation, this.mediator, p)});
    }

    public boolean isReady(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        if (re == null) {
            return false;
        }
        DingAnnotation annotation = re.getPicker().getAnnotationAt(javaPt);
        return annotation != null;
    }
}

