/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.AnnotationFactoryManager;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class DuplicateAnnotationsTask
extends AbstractTask {
    private static final double SHIFT = 15.0;
    private final DRenderingEngine re;
    private final Collection<DingAnnotation> annotations;
    private final AnnotationFactoryManager annotationFactoryManager;

    public DuplicateAnnotationsTask(DRenderingEngine re, Collection<DingAnnotation> annotations, AnnotationFactoryManager annotationFactoryManager) {
        this.re = re;
        this.annotations = annotations;
        this.annotationFactoryManager = annotationFactoryManager;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Duplicate Selected Annotations");
        tm.setProgress(-1.0);
        if (this.re != null && !this.annotations.isEmpty()) {
            CyAnnotator annotator = this.re.getCyAnnotator();
            annotator.markUndoEdit("Duplicate Selected Annotations");
            HashMap<DingAnnotation, DingAnnotation> oldNewMap = new HashMap<DingAnnotation, DingAnnotation>();
            HashSet<ArrowAnnotationImpl> newArrows = new HashSet<ArrowAnnotationImpl>();
            for (DingAnnotation a : this.annotations) {
                DingAnnotation copy = this.duplicate(a);
                annotator.addAnnotation(copy);
                oldNewMap.put(a, copy);
                if (!(copy instanceof ArrowAnnotationImpl)) continue;
                newArrows.add((ArrowAnnotationImpl)copy);
            }
            for (ArrowAnnotationImpl arrow : newArrows) {
                DingAnnotation src = (DingAnnotation)oldNewMap.get(arrow.getSource());
                if (src != null && annotator.contains(src)) {
                    arrow.setSource(src);
                    Object tgt = arrow.getTarget();
                    if (!(tgt instanceof DingAnnotation)) continue;
                    arrow.setTarget((Annotation)oldNewMap.get(tgt));
                    continue;
                }
                arrow.removeAnnotation();
                oldNewMap.values().remove(arrow);
            }
            ViewUtils.reorder(new ArrayList<DingAnnotation>(oldNewMap.values()), AnnotationTree.Shift.TO_FRONT, this.re);
            annotator.clearSelectedAnnotations();
            for (DingAnnotation copy : oldNewMap.values()) {
                copy.setSelected(true);
            }
            annotator.postUndoEdit();
        }
    }

    private DingAnnotation duplicate(DingAnnotation a) {
        DingAnnotation copy;
        HashMap<String, String> argMap = new HashMap<String, String>(a.getArgMap());
        argMap.remove("uuid");
        String type = (String)argMap.get("type");
        if (type == null) {
            type = a.getClass().getName();
        }
        if ((copy = (DingAnnotation)this.annotationFactoryManager.createAnnotation(type, this.re.getViewModel(), argMap)) instanceof ArrowAnnotation) {
            ((ArrowAnnotation)copy).setSource(((ArrowAnnotation)a).getSource());
            Object tgt = ((ArrowAnnotation)a).getTarget();
            if (tgt instanceof Annotation) {
                ((ArrowAnnotation)copy).setTarget((Annotation)tgt);
            } else if (tgt instanceof CyNode) {
                ((ArrowAnnotation)copy).setTarget((CyNode)tgt);
            } else if (tgt instanceof Point2D) {
                ((ArrowAnnotation)copy).setTarget((Point2D)tgt);
            }
        } else {
            copy.moveAnnotation(new Point2D.Double(a.getX() + 15.0, a.getY() + 15.0));
        }
        return copy;
    }
}

