/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingRenderer;
import org.cytoscape.ding.impl.cyannotator.AnnotationClipboard;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.CopyAnnotationStyleTask;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class CopyAnnotationStyleTaskFactory
implements NetworkViewTaskFactory,
NetworkViewLocationTaskFactory {
    private final DingRenderer dingRenderer;
    private final AnnotationClipboard clipboard;

    public CopyAnnotationStyleTaskFactory(DingRenderer dingRenderer, AnnotationClipboard clipboard) {
        this.dingRenderer = dingRenderer;
        this.clipboard = clipboard;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView) {
        Collection<DingAnnotation> annotations = this.getSelectedAnnotations(networkView);
        if (annotations != null && annotations.size() == 1) {
            return new TaskIterator(new Task[]{new CopyAnnotationStyleTask(annotations.iterator().next(), this.clipboard)});
        }
        return null;
    }

    public TaskIterator createTaskIterator(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        DingAnnotation annotation = re != null ? re.getPicker().getAnnotationAt(javaPt) : null;
        return annotation != null ? new TaskIterator(new Task[]{new CopyAnnotationStyleTask(annotation, this.clipboard)}) : null;
    }

    public boolean isReady(CyNetworkView networkView) {
        Collection<DingAnnotation> annotations = this.getSelectedAnnotations(networkView);
        return annotations != null && annotations.size() == 1;
    }

    public boolean isReady(CyNetworkView networkView, Point2D javaPt, Point2D xformPt) {
        DRenderingEngine re = this.dingRenderer.getRenderingEngine(networkView);
        DingAnnotation annotation = re != null ? re.getPicker().getAnnotationAt(javaPt) : null;
        return annotation != null && annotation.getArgMap() != null;
    }

    private Collection<DingAnnotation> getSelectedAnnotations(CyNetworkView networkView) {
        DRenderingEngine re = networkView != null ? this.dingRenderer.getRenderingEngine(networkView) : null;
        CyAnnotator cyAnnotator = re != null ? re.getCyAnnotator() : null;
        List<DingAnnotation> annotations = cyAnnotator != null ? cyAnnotator.getAnnotationSelection().getSelectedAnnotations() : null;
        return annotations;
    }
}

