/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.tasks;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Collections;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.create.AbstractDingAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.ArrowAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.create.ImageAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.ding.impl.cyannotator.dialogs.LoadImageDialog;
import org.cytoscape.ding.impl.cyannotator.ui.AnnotationMediator;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class AddAnnotationTask
extends AbstractTask {
    private final DRenderingEngine re;
    private final Point location;
    private final AnnotationFactory annotationFactory;
    private final AnnotationMediator annotationMediator;

    public AddAnnotationTask(DRenderingEngine re, Point location, AnnotationFactory<?> annotationFactory, AnnotationMediator annotationMediator) {
        this.re = re;
        this.location = location != null ? location : re.getComponentCenter();
        this.annotationFactory = annotationFactory;
        this.annotationMediator = annotationMediator;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Add Annotation");
        if (this.re != null && this.annotationFactory instanceof AbstractDingAnnotationFactory) {
            ViewUtil.invokeOnEDT(() -> {
                Object annotation;
                CyAnnotator cyAnnotator = this.re.getCyAnnotator();
                cyAnnotator.markUndoEdit("Create " + this.annotationFactory.getName() + " Annotation");
                CyNetworkView view = this.re.getViewModel();
                DingAnnotation source = this.re.getPicker().getAnnotationAt(this.location);
                if (this.annotationFactory instanceof ImageAnnotationFactory) {
                    LoadImageDialog dialog = ((ImageAnnotationFactory)this.annotationFactory).createLoadImageDialog(view, this.location);
                    dialog.setVisible(true);
                    annotation = dialog.getAnnotation();
                    if (annotation == null) {
                        return;
                    }
                } else {
                    if (this.annotationFactory instanceof ArrowAnnotationFactory && (source == null || source instanceof ArrowAnnotation)) {
                        return;
                    }
                    annotation = this.annotationFactory.createAnnotation(this.annotationFactory.getType(), view, Collections.emptyMap());
                    tm.setStatusMessage("Created annotation: " + annotation.getName());
                }
                AbstractAnnotationEditor<Annotation> editor = ((AbstractDingAnnotationFactory)this.annotationFactory).getEditor();
                if (editor != null) {
                    editor.apply((Annotation)annotation);
                }
                if (annotation instanceof ArrowAnnotationImpl) {
                    ((ArrowAnnotationImpl)annotation).setSource(source);
                    cyAnnotator.addAnnotation((Annotation)annotation);
                    cyAnnotator.positionArrow((ArrowAnnotationImpl)annotation);
                    annotation.update();
                } else {
                    if (annotation instanceof DingAnnotation) {
                        Point2D annotationLocation = this.re.getTransform().getNodeCoordinates(this.location);
                        ((DingAnnotation)annotation).setLocation(annotationLocation.getX(), annotationLocation.getY());
                        annotation.update();
                    }
                    cyAnnotator.addAnnotation((Annotation)annotation);
                    if (annotation instanceof DingAnnotation) {
                        cyAnnotator.clearSelectedAnnotations();
                        ViewUtils.selectAnnotation(this.re, (DingAnnotation)annotation);
                    }
                }
                cyAnnotator.postUndoEdit();
                this.annotationMediator.editAnnotation((Annotation)annotation);
            });
        }
    }
}

