/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.ding.impl.cyannotator.dialogs.AbstractAnnotationEditor;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.color.BrewerType;
import org.cytoscape.util.color.PaletteType;
import org.cytoscape.util.swing.ColorButton;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.TextAnnotation;

public class TextAnnotationEditor
extends AbstractAnnotationEditor<TextAnnotation> {
    private static final String PLAIN = "Plain";
    private static final String BOLD = "Bold";
    private static final String ITALIC = "Italic";
    private static final String BOLD_ITALIC = "Bold and Italic";
    private static final String[] FONT_STYLES = new String[]{"Plain", "Bold", "Italic", "Bold and Italic"};
    private static final Font[] FONTS = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    private static final Integer[] FONT_SIZES = new Integer[]{10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36};
    private JTextField textField;
    private JComboBox<Integer> fontSizeCombo;
    private JComboBox<String> fontStyleCombo;
    private JComboBox<Font> fontFamilyCombo;
    private ColorButton textColorButton;
    private JPanel rotationPanel;
    private JSlider rotationSlider;
    private final boolean rotatable;

    public TextAnnotationEditor(AnnotationFactory<TextAnnotation> factory, CyServiceRegistrar serviceRegistrar) {
        this(factory, true, serviceRegistrar);
    }

    public TextAnnotationEditor(AnnotationFactory<TextAnnotation> factory, boolean rotatable, CyServiceRegistrar serviceRegistrar) {
        super(factory, serviceRegistrar);
        this.rotatable = rotatable;
        if (!rotatable) {
            this.getRotationPanel().setVisible(false);
        }
    }

    @Override
    protected void doUpdate() {
        if (this.annotation != null) {
            int fontSize;
            this.getTextField().setText(((TextAnnotation)this.annotation).getText());
            if (((TextAnnotation)this.annotation).getFont().getStyle() == 0) {
                this.getFontStyleCombo().setSelectedItem(FONT_STYLES[0]);
            } else if (((TextAnnotation)this.annotation).getFont().getStyle() == 1) {
                this.getFontStyleCombo().setSelectedItem(FONT_STYLES[1]);
            } else if (((TextAnnotation)this.annotation).getFont().getStyle() == 2) {
                this.getFontStyleCombo().setSelectedItem(FONT_STYLES[2]);
            } else {
                this.getFontStyleCombo().setSelectedItem(FONT_STYLES[3]);
            }
            ComboBoxModel<Font> model = this.getFontFamilyCombo().getModel();
            int total = model.getSize();
            if (((TextAnnotation)this.annotation).getFont() != null) {
                for (int i = 0; i < total; ++i) {
                    if (!((TextAnnotation)this.annotation).getFont().getFontName().equals(((Font)model.getElementAt(i)).getFontName())) continue;
                    this.getFontFamilyCombo().setSelectedItem(FONTS[i]);
                    break;
                }
            }
            int n = fontSize = ((TextAnnotation)this.annotation).getFont() != null ? ((TextAnnotation)this.annotation).getFont().getSize() : FONT_SIZES[2].intValue();
            if (fontSize % 2 == 0 && fontSize >= FONT_SIZES[0] && fontSize <= FONT_SIZES[FONT_SIZES.length - 1]) {
                ComboBoxModel<Integer> model2 = this.getFontSizeCombo().getModel();
                int total2 = model2.getSize();
                for (int i = 0; i < total2; ++i) {
                    if (fontSize != (Integer)model2.getElementAt(i)) continue;
                    this.getFontSizeCombo().setSelectedItem(FONT_SIZES[i]);
                    break;
                }
            } else {
                this.getFontSizeCombo().getEditor().setItem(fontSize);
            }
            this.getTextColorButton().setColor(((TextAnnotation)this.annotation).getTextColor());
            if (this.rotatable) {
                double rotation = ((TextAnnotation)this.annotation).getRotation();
                this.getRotationSlider().setValue((int)rotation);
            }
        } else {
            this.getTextField().setText("Text");
        }
    }

    @Override
    public void apply(TextAnnotation annotation) {
        if (annotation != null) {
            annotation.setFont(this.getNewFont());
            annotation.setText(this.getTextField().getText());
            annotation.setTextColor(this.getTextColorButton().getColor());
            if (this.rotatable) {
                annotation.setRotation((double)this.getRotationSlider().getValue());
            }
        }
    }

    @Override
    protected void init() {
        JLabel textLabel = new JLabel("Text:");
        JLabel fontLabel = new JLabel("Font:");
        JLabel styleLabel = new JLabel("Style:");
        JLabel sizeLabel = new JLabel("Size:");
        JSeparator sep = new JSeparator();
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 20, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(textLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.getTextField(), -1, -1, Short.MAX_VALUE).addComponent((Component)this.getTextColorButton(), -2, -1, -2)).addComponent(sep, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(fontLabel).addComponent(this.getFontFamilyCombo())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(styleLabel).addComponent(this.getFontStyleCombo())).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(sizeLabel).addComponent(this.getFontSizeCombo()))).addGroup(layout.createSequentialGroup().addComponent(this.getFontStyleCombo(), -2, -1, -2).addComponent(this.getFontSizeCombo(), -2, -1, -2)).addComponent(this.getRotationPanel(), -1, -1, Short.MAX_VALUE).addGap(0, 20, Short.MAX_VALUE)).addGap(0, 20, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(textLabel).addComponent(this.getTextField(), -2, -1, -2).addComponent((Component)this.getTextColorButton(), -2, -1, -2)).addComponent(sep, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(fontLabel, -2, -1, -2).addComponent(this.getFontFamilyCombo(), -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(styleLabel, -2, -1, -2).addComponent(this.getFontStyleCombo(), -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(sizeLabel, -2, -1, -2).addComponent(this.getFontSizeCombo(), -2, -1, -2))).addComponent(this.getRotationPanel(), -2, -1, -2));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{textLabel, fontLabel, styleLabel, sizeLabel});
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getTextField(), this.getTextColorButton(), this.getFontFamilyCombo(), this.getFontStyleCombo(), this.getFontSizeCombo()});
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent evt) {
                    TextAnnotationEditor.this.apply();
                }

                @Override
                public void insertUpdate(DocumentEvent evt) {
                    TextAnnotationEditor.this.apply();
                }

                @Override
                public void changedUpdate(DocumentEvent evt) {
                }
            });
        }
        return this.textField;
    }

    private JComboBox<Integer> getFontSizeCombo() {
        if (this.fontSizeCombo == null) {
            this.fontSizeCombo = new JComboBox();
            this.fontSizeCombo.setModel(new DefaultComboBoxModel<Integer>(FONT_SIZES));
            this.fontSizeCombo.setEditable(true);
            this.fontSizeCombo.setSelectedItem(FONT_SIZES[2]);
            this.fontSizeCombo.addActionListener(evt -> this.apply());
        }
        return this.fontSizeCombo;
    }

    private JComboBox<String> getFontStyleCombo() {
        if (this.fontStyleCombo == null) {
            this.fontStyleCombo = new JComboBox();
            this.fontStyleCombo.setModel(new DefaultComboBoxModel<String>(FONT_STYLES));
            this.fontStyleCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setFont(this.getFont().deriveFont(0));
                    if (TextAnnotationEditor.BOLD.equals(value)) {
                        this.setFont(this.getFont().deriveFont(1));
                    } else if (TextAnnotationEditor.ITALIC.equals(value)) {
                        this.setFont(this.getFont().deriveFont(2));
                    } else if (TextAnnotationEditor.BOLD_ITALIC.equals(value)) {
                        this.setFont(this.getFont().deriveFont(3));
                    }
                    return this;
                }
            });
            this.fontStyleCombo.setSelectedItem(FONT_STYLES[0]);
            this.fontStyleCombo.addActionListener(evt -> this.apply());
        }
        return this.fontStyleCombo;
    }

    private JComboBox<Font> getFontFamilyCombo() {
        if (this.fontFamilyCombo == null) {
            this.fontFamilyCombo = new JComboBox();
            this.fontFamilyCombo.setModel(new DefaultComboBoxModel<Font>(FONTS));
            this.fontFamilyCombo.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setFont(((Font)value).deriveFont(LookAndFeelUtil.getSmallFontSize()));
                    this.setText(((Font)value).getFontName());
                    this.setToolTipText(((Font)value).getFontName());
                    return this;
                }
            });
            this.fontFamilyCombo.setSelectedItem(UIManager.getFont("Label.font").getFontName());
            this.fontFamilyCombo.addActionListener(evt -> this.apply());
        }
        return this.fontFamilyCombo;
    }

    private ColorButton getTextColorButton() {
        if (this.textColorButton == null) {
            this.textColorButton = new ColorButton(this.serviceRegistrar, null, (PaletteType)BrewerType.ANY, Color.BLACK, false);
            this.textColorButton.setToolTipText("Select text color...");
            this.textColorButton.addPropertyChangeListener("color", evt -> this.apply());
        }
        return this.textColorButton;
    }

    private JPanel getRotationPanel() {
        if (this.rotationPanel == null) {
            this.rotationPanel = new JPanel();
            this.rotationPanel.setOpaque(!LookAndFeelUtil.isAquaLAF());
            JLabel rotationLabel = TextAnnotationEditor.createRotationLabel();
            JSeparator sep = new JSeparator();
            GroupLayout layout = new GroupLayout(this.rotationPanel);
            this.rotationPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(sep, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(rotationLabel, -2, -1, -2).addComponent(this.getRotationSlider(), -2, -1, -2)));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(sep, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(rotationLabel).addComponent(this.getRotationSlider(), -2, -1, -2)));
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{rotationLabel, this.getRotationSlider()});
        }
        return this.rotationPanel;
    }

    private JSlider getRotationSlider() {
        if (this.rotationSlider == null) {
            this.rotationSlider = this.createRotationSlider();
        }
        return this.rotationSlider;
    }

    private Font getNewFont() {
        int fontStyle = 0;
        if (PLAIN.equals(this.getFontStyleCombo().getSelectedItem())) {
            fontStyle = 0;
        } else if (BOLD.equals(this.getFontStyleCombo().getSelectedItem())) {
            fontStyle = 1;
        } else if (ITALIC.equals(this.getFontStyleCombo().getSelectedItem())) {
            fontStyle = 2;
        } else if (BOLD_ITALIC.equals(this.getFontStyleCombo().getSelectedItem())) {
            fontStyle = 3;
        }
        Font font = (Font)this.getFontFamilyCombo().getSelectedItem();
        Integer size = (Integer)this.getFontSizeCombo().getEditor().getItem();
        return font.deriveFont(fontStyle, size.floatValue());
    }
}

