/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.cytoscape.cg.model.AbstractURLImageCustomGraphics;
import org.cytoscape.cg.model.BitmapCustomGraphics;
import org.cytoscape.cg.model.CustomGraphicsManager;
import org.cytoscape.cg.model.SVGCustomGraphics;
import org.cytoscape.cg.model.SVGLayer;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.ShapeAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.ding.internal.util.ImageUtil;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageAnnotationImpl
extends ShapeAnnotationImpl
implements ImageAnnotation {
    private String svg;
    private BufferedImage image;
    private BufferedImage modifiedImage;
    private URL url;
    private float opacity = 1.0f;
    private int brightness;
    private int contrast;
    private CyCustomGraphics<?> cg;
    protected final CustomGraphicsManager customGraphicsManager;
    private static final Logger logger = LoggerFactory.getLogger(ImageAnnotationImpl.class);

    public ImageAnnotationImpl(ImageAnnotationImpl annotation, boolean usedForPreviews) {
        super(annotation, 0.0, 0.0, usedForPreviews);
        if (annotation == null) {
            throw new IllegalArgumentException("'annotation' must not be null.");
        }
        this.image = annotation.image;
        this.svg = annotation.svg;
        this.customGraphicsManager = annotation.customGraphicsManager;
        this.cg = annotation.cg;
        this.width = annotation.getWidth();
        this.height = annotation.getHeight();
        this.url = annotation.url;
        this.opacity = annotation.opacity;
        this.brightness = annotation.brightness;
        this.contrast = annotation.contrast;
        this.setBorderWidth(0.0);
        this.name = annotation.getName() != null ? annotation.getName() : this.getDefaultName();
    }

    public ImageAnnotationImpl(DRenderingEngine re, double x, double y, double rotation, URL url, BufferedImage image, double zoom, CustomGraphicsManager customGraphicsManager) {
        super(re, x, y, rotation, ShapeAnnotation.ShapeType.RECTANGLE, 0.0, 0.0, null, null, 0.0f);
        if (image == null) {
            throw new IllegalArgumentException("'image' must not be null.");
        }
        if (customGraphicsManager == null) {
            throw new IllegalArgumentException("'customGraphicsManager' must not be null.");
        }
        this.image = image;
        this.customGraphicsManager = customGraphicsManager;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.url = url;
        this.cg = new BitmapCustomGraphics(customGraphicsManager.getNextAvailableID(), url.toString(), image);
        customGraphicsManager.addCustomGraphics(this.cg, url);
        customGraphicsManager.setUsedInCurrentSession(this.cg, Boolean.valueOf(true));
        this.name = this.getDefaultName();
    }

    public ImageAnnotationImpl(DRenderingEngine re, double x, double y, double rotation, URL url, String svg, double zoom, CustomGraphicsManager customGraphicsManager) {
        super(re, x, y, rotation, ShapeAnnotation.ShapeType.RECTANGLE, 0.0, 0.0, null, null, 0.0f);
        if (svg == null) {
            throw new IllegalArgumentException("'svg' must not be null.");
        }
        if (customGraphicsManager == null) {
            throw new IllegalArgumentException("'customGraphicsManager' must not be null.");
        }
        this.svg = svg;
        this.customGraphicsManager = customGraphicsManager;
        this.url = url;
        try {
            this.cg = new SVGCustomGraphics(customGraphicsManager.getNextAvailableID(), url.toString(), url, svg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.width = this.cg.getWidth();
        this.height = this.cg.getHeight();
        customGraphicsManager.addCustomGraphics(this.cg, url);
        customGraphicsManager.setUsedInCurrentSession(this.cg, Boolean.valueOf(true));
        this.name = this.getDefaultName();
    }

    public ImageAnnotationImpl(DRenderingEngine re, AbstractURLImageCustomGraphics<?> cg, int x, int y, double rotation, double zoom, CustomGraphicsManager customGraphicsManager) {
        super(re, x, y, rotation, ShapeAnnotation.ShapeType.RECTANGLE, 0.0, 0.0, null, null, 0.0f);
        if (cg == null) {
            throw new IllegalArgumentException("'cg' must not be null.");
        }
        if (customGraphicsManager == null) {
            throw new IllegalArgumentException("'customGraphicsManager' must not be null.");
        }
        this.cg = cg;
        this.url = cg.getSourceURL();
        this.customGraphicsManager = customGraphicsManager;
        if (cg instanceof SVGCustomGraphics) {
            this.svg = ((SVGCustomGraphics)cg).getSVG();
            this.width = cg.getWidth();
            this.height = cg.getHeight();
        } else if (cg instanceof BitmapCustomGraphics) {
            this.image = ((BitmapCustomGraphics)cg).getOriginalImage();
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
        } else {
            throw new IllegalArgumentException("'cg' must be a BitmapCustomGraphics or SVGCustomGraphics.");
        }
        customGraphicsManager.addCustomGraphics(cg, this.url);
        customGraphicsManager.setUsedInCurrentSession(cg, Boolean.valueOf(true));
        this.name = this.getDefaultName();
    }

    public ImageAnnotationImpl(DRenderingEngine re, Map<String, String> argMap, CustomGraphicsManager customGraphicsManager) {
        super(re, argMap);
        if (argMap == null) {
            throw new IllegalArgumentException("'argMap' must not be null.");
        }
        if (customGraphicsManager == null) {
            throw new IllegalArgumentException("'customGraphicsManager' must not be null.");
        }
        this.customGraphicsManager = customGraphicsManager;
        this.opacity = ImageAnnotationImpl.clamp(ViewUtils.getFloat(argMap, "opacity", 1.0f).floatValue(), 0.0f, 1.0f);
        this.brightness = ViewUtils.getInteger(argMap, "brightness", 0);
        this.contrast = ViewUtils.getInteger(argMap, "contrast", 0);
        if (argMap.containsKey("URL")) {
            try {
                this.url = new URL(argMap.get("URL"));
                this.reloadImage();
                if (this.name == null) {
                    this.name = this.getDefaultName();
                }
                double aspectRatio = (double)this.image.getHeight() / (double)this.image.getWidth();
                if (argMap.containsKey("width") && argMap.containsKey("height")) {
                    return;
                }
                if (argMap.containsKey("width")) {
                    this.height = this.width * aspectRatio;
                } else {
                    this.width = this.height / aspectRatio;
                }
            }
            catch (Exception e) {
                logger.warn("Unable to restore image '" + argMap.get("URL") + "'", (Throwable)e);
            }
        }
    }

    public ImageAnnotationImpl(DRenderingEngine re, boolean usedForPreviews, CustomGraphicsManager customGraphicsManager) {
        super(re, 0.0, 0.0, usedForPreviews);
        if (customGraphicsManager == null) {
            throw new IllegalArgumentException("'customGraphicsManager' must not be null.");
        }
        this.customGraphicsManager = customGraphicsManager;
    }

    public void preserveCustomGraphics() {
        for (CyCustomGraphics cg : this.customGraphicsManager.getAllCustomGraphics()) {
            this.customGraphicsManager.setUsedInCurrentSession(cg, Boolean.valueOf(true));
        }
    }

    private static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    @Override
    public Class<? extends Annotation> getType() {
        return ImageAnnotation.class;
    }

    @Override
    public Map<String, String> getArgMap() {
        Map<String, String> argMap = super.getArgMap();
        if (argMap.containsKey("fillOpacity")) {
            argMap.remove("fillOpacity");
        }
        if (argMap.containsKey("fillColor")) {
            argMap.remove("fillColor");
        }
        argMap.put("type", ImageAnnotation.class.getName());
        if (this.url != null) {
            argMap.put("URL", this.url.toString());
        }
        argMap.put("width", Double.toString(this.width));
        argMap.put("height", Double.toString(this.height));
        argMap.put("opacity", Float.toString(this.opacity));
        argMap.put("brightness", Integer.toString(this.brightness));
        argMap.put("contrast", Integer.toString(this.contrast));
        if (this.cg != null) {
            this.customGraphicsManager.setUsedInCurrentSession(this.cg, Boolean.valueOf(true));
        }
        return argMap;
    }

    @Override
    public void setStyle(Map<String, String> argMap) {
        super.setStyle(argMap);
        if (argMap != null) {
            this.setImageOpacity(ViewUtils.getFloat(argMap, "opacity", 1.0f).floatValue());
            this.setImageBrightness(ViewUtils.getInteger(argMap, "brightness", 0));
            this.setImageContrast(ViewUtils.getInteger(argMap, "contrast", 0));
        }
    }

    public void reloadImage() {
        block6: {
            try {
                this.cg = this.customGraphicsManager.getCustomGraphicsBySourceURL(this.url);
                if (this.cg != null) {
                    if (!this.isSVG()) {
                        this.image = ImageUtil.toBufferedImage(this.cg.getRenderedImage());
                    }
                    this.modifiedImage = null;
                    this.customGraphicsManager.addCustomGraphics(this.cg, this.url);
                    this.customGraphicsManager.setUsedInCurrentSession(this.cg, Boolean.valueOf(true));
                    break block6;
                }
                try {
                    this.image = ImageIO.read(this.url);
                    this.cg = new BitmapCustomGraphics(this.customGraphicsManager.getNextAvailableID(), this.url.toString(), this.image);
                    this.customGraphicsManager.addCustomGraphics(this.cg, this.url);
                    this.customGraphicsManager.setUsedInCurrentSession(this.cg, Boolean.valueOf(true));
                    this.modifiedImage = null;
                }
                catch (Exception e) {
                    logger.error("Unable to read image from " + this.url.toString() + ": " + e.getMessage());
                    throw e;
                }
            }
            catch (Exception e) {
                logger.warn("Unable to restore image '" + this.url + "'", (Throwable)e);
                return;
            }
        }
    }

    public Image getImage() {
        if (this.image == null) {
            return this.getModifiedImage();
        }
        return this.image;
    }

    public void setImage(Image image) {
        BufferedImage oldValue = this.image;
        if (image instanceof BufferedImage) {
            this.image = (BufferedImage)image;
        } else if (image instanceof VolatileImage) {
            this.image = ((VolatileImage)image).getSnapshot();
        } else {
            return;
        }
        this.svg = null;
        this.update();
        this.firePropertyChange("image", oldValue, image);
    }

    public String getSVG() {
        return this.svg;
    }

    public void setSVG(String svg) {
        this.svg = svg;
        this.image = null;
        this.update();
    }

    public void setImage(URL url) {
        URL oldValue = this.url;
        this.url = url;
        this.reloadImage();
        this.getModifiedImage();
        this.update();
        this.firePropertyChange("imageURL", oldValue, url);
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setImageOpacity(float opacity) {
        if (this.opacity != (opacity = ImageAnnotationImpl.clamp(opacity, 0.0f, 1.0f))) {
            float oldValue = this.opacity;
            this.opacity = opacity;
            this.update();
            this.firePropertyChange("imageOpacity", Float.valueOf(oldValue), Float.valueOf(opacity));
        }
    }

    public float getImageOpacity() {
        return this.opacity;
    }

    public void setImageBrightness(int brightness) {
        if (this.brightness != brightness) {
            int oldValue = this.brightness;
            this.brightness = brightness;
            this.modifiedImage = null;
            this.update();
            this.firePropertyChange("imageBrightness", oldValue, brightness);
        }
    }

    public int getImageBrightness() {
        return this.brightness;
    }

    public void setImageContrast(int contrast) {
        if (this.contrast != contrast) {
            int oldValue = this.contrast;
            this.contrast = contrast;
            this.modifiedImage = null;
            this.update();
            this.firePropertyChange("imageContrast", oldValue, contrast);
        }
    }

    public int getImageContrast() {
        return this.contrast;
    }

    @Override
    public void setSize(double width, double height) {
        if (this.width != width || this.height != height) {
            super.setSize(width, height);
            if (this.isSVG()) {
                this.modifiedImage = null;
                this.update();
            }
        }
    }

    @Override
    public List<String> getSupportedShapes() {
        return Collections.singletonList(ShapeAnnotation.ShapeType.RECTANGLE.shapeName());
    }

    @Override
    public String getShapeType() {
        return ShapeAnnotation.ShapeType.RECTANGLE.shapeName();
    }

    @Override
    public void setCustomShape(Shape shape) {
    }

    @Override
    public void setShapeType(String type) {
    }

    @Override
    public Paint getFillColor() {
        return null;
    }

    @Override
    public double getFillOpacity() {
        return 0.0;
    }

    @Override
    public void setFillColor(Paint fill) {
    }

    @Override
    public void setFillOpacity(double opacity) {
    }

    @Override
    public Shape getShape() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.width, this.height);
    }

    @Override
    protected String getDefaultName() {
        if (this.url != null) {
            try {
                String fileName = Paths.get(new URI(this.url.toString()).getPath(), new String[0]).getFileName().toString();
                return fileName;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getDefaultName();
    }

    public boolean isSVG() {
        return this.cg instanceof SVGCustomGraphics || this.svg != null;
    }

    public void dropImage() {
        this.customGraphicsManager.setUsedInCurrentSession(this.cg, Boolean.valueOf(false));
    }

    private Image getModifiedImage() {
        if (this.modifiedImage != null) {
            return this.modifiedImage;
        }
        BufferedImage image = null;
        if (this.isSVG()) {
            int w = Math.max(1, (int)Math.round(this.getWidth()));
            int h = Math.max(1, (int)Math.round(this.getHeight()));
            Rectangle2D.Float rect = new Rectangle2D.Float((float)w / 2.0f, (float)h / 2.0f, w, h);
            image = new BufferedImage(w, h, 2);
            Graphics2D g = image.createGraphics();
            List layers = ((SVGCustomGraphics)this.cg).getLayers();
            for (SVGLayer cgl : layers) {
                if (!(cgl instanceof SVGLayer)) continue;
                cgl.draw(g, (Shape)rect, (Rectangle2D)rect);
            }
            g.dispose();
        } else {
            image = this.image;
        }
        if (image != null) {
            if (this.brightness == 0 && this.contrast == 0) {
                this.modifiedImage = image;
            } else {
                BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                Graphics2D g = rgbImage.createGraphics();
                g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                this.modifiedImage = rgbImage;
                g.dispose();
                float offset = (float)this.brightness * 255.0f / 100.0f;
                float scaleFactor = 1.0f;
                scaleFactor = this.contrast <= 0 ? 1.0f + (float)this.contrast / 100.0f : 1.0f + (float)this.contrast * 3.0f / 100.0f;
                RescaleOp op = new RescaleOp(scaleFactor, offset, null);
                op.filter(this.modifiedImage, this.modifiedImage);
            }
        }
        return this.modifiedImage;
    }

    @Override
    public void paint(Graphics g, boolean showSelection) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, this.opacity));
        if (this.isSVG()) {
            double w = Math.max(1.0, this.getWidth());
            double h = Math.max(1.0, this.getHeight());
            Rectangle2D.Double rect = new Rectangle2D.Double(this.getX() + w / 2.0, this.getY() + h / 2.0, w, h);
            List layers = ((SVGCustomGraphics)this.cg).getLayers();
            for (SVGLayer cgl : layers) {
                if (!(cgl instanceof SVGLayer)) continue;
                cgl.draw(g2, (Shape)rect, (Rectangle2D)rect);
            }
        } else {
            Image image = this.getModifiedImage();
            if (image != null) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                AffineTransform currentTransform = g2.getTransform();
                if (this.rotation != 0.0) {
                    g2.rotate(Math.toRadians(this.rotation), (int)(this.getX() + this.getWidth() / 2.0), (int)(this.getY() + this.getHeight() / 2.0));
                }
                g2.drawImage(image, Math.round((float)this.getX()), Math.round((float)this.getY()), Math.round((float)this.getWidth()), Math.round((float)this.getHeight()), null);
                g2.setTransform(currentTransform);
            }
        }
        g2.dispose();
        super.paint(g, showSelection);
    }
}

