/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.IllegalAnnotationStructureException;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;

public class GroupAnnotationImpl
extends AbstractAnnotation
implements GroupAnnotation {
    private List<DingAnnotation> annotations = new ArrayList<DingAnnotation>();

    public GroupAnnotationImpl(DRenderingEngine re, Map<String, String> argMap) {
        super(re, GroupAnnotationImpl.processArgs(argMap));
    }

    private static Map<String, String> processArgs(Map<String, String> argMap) {
        argMap.remove("canvas");
        return argMap;
    }

    @Override
    public Class<? extends Annotation> getType() {
        return GroupAnnotation.class;
    }

    @Override
    public void setCanvas(String cnvs) {
    }

    public void addMember(Annotation member) {
        if (member instanceof DingAnnotation) {
            DingAnnotation dMember = (DingAnnotation)member;
            if (dMember.getGroupParent() != null && dMember.getGroupParent() != this) {
                throw new IllegalAnnotationStructureException("Annotation is already a member of another group.");
            }
            if (!this.annotations.contains(dMember)) {
                this.annotations.add(dMember);
                dMember.setGroupParent(this);
                try {
                    this.getCyAnnotator().checkCycle();
                }
                catch (IllegalAnnotationStructureException e) {
                    this.annotations.remove(dMember);
                    dMember.setGroupParent(null);
                    throw e;
                }
            }
            this.updateBounds();
            Rectangle2D bounds = this.getBounds();
            this.setLocation((int)bounds.getX(), (int)bounds.getY());
            this.setSize((int)bounds.getWidth(), (int)bounds.getHeight());
        }
    }

    public List<Annotation> getMembers() {
        return new ArrayList<Annotation>(this.annotations);
    }

    public void removeMember(Annotation member) {
        if (member instanceof DingAnnotation) {
            DingAnnotation dMember = (DingAnnotation)member;
            if (this.annotations != null && this.annotations.contains(dMember)) {
                this.annotations.remove(dMember);
                dMember.setGroupParent(null);
            }
            this.updateBounds();
        }
    }

    @Override
    public void removeAnnotation() {
        for (DingAnnotation a : this.annotations) {
            this.cyAnnotator.removeAnnotation(a);
        }
        this.annotations.clear();
        this.cyAnnotator.removeAnnotation(this);
        if (this.groupParent != null) {
            this.groupParent.removeMember(this);
        }
    }

    @Override
    public Map<String, String> getArgMap() {
        Map<String, String> argMap = super.getArgMap();
        argMap.put("type", GroupAnnotation.class.getName());
        Object members = "";
        if (this.annotations == null || this.annotations.size() == 0) {
            return argMap;
        }
        for (DingAnnotation a : this.annotations) {
            members = (String)members + a.getUUID().toString() + ",";
        }
        if (members != null && ((String)members).length() > 1) {
            argMap.put("memberUUIDs", ((String)members).substring(0, ((String)members).length() - 1));
        }
        return argMap;
    }

    @Override
    public void setStyle(Map<String, String> argMap) {
        if (argMap != null) {
            for (DingAnnotation a : this.annotations) {
                a.setStyle(argMap);
            }
        }
    }

    @Override
    public void setLocation(double x, double y) {
        double deltaX = this.getX() - x;
        double deltaY = this.getY() - y;
        for (DingAnnotation child : this.annotations) {
            double x2 = child.getX() - deltaX;
            double y2 = child.getY() - deltaY;
            if (child.getX() == x2 && child.getY() == y2) continue;
            child.setLocation(x2, y2);
        }
        this.updateBounds();
    }

    @Override
    public void resizeAnnotationRelative(Rectangle2D initialBounds, Rectangle2D outlineBounds) {
        for (DingAnnotation a : this.annotations) {
            ((AbstractAnnotation)a).resizeAnnotationRelative(initialBounds, outlineBounds);
        }
        this.updateBounds();
    }

    @Override
    public void saveBounds() {
        super.saveBounds();
        for (DingAnnotation a : this.annotations) {
            ((AbstractAnnotation)a).saveBounds();
        }
    }

    @Override
    public void changeCanvas(DingAnnotation.CanvasID canvasId) {
        for (DingAnnotation a : this.annotations) {
            a.changeCanvas(canvasId);
        }
        super.changeCanvas(canvasId);
    }

    @Override
    public void setRotation(double rotation) {
        double oldValue = this.rotation;
        super.setRotation(rotation);
        double deltaRotation = this.rotation - oldValue;
        double centerX = this.getCenter(this.getBounds()).getX();
        double centerY = this.getCenter(this.getBounds()).getY();
        for (DingAnnotation a : this.annotations) {
            a.setRotation(a.getRotation() + deltaRotation);
            double angle = deltaRotation;
            Rectangle2D bounds = a.getBounds();
            Point2D aCenter = this.getCenter(bounds);
            double x = aCenter.getX() - centerX;
            double y = aCenter.getY() - centerY;
            if (!(Math.abs(x) > 0.1) && !(Math.abs(y) > 0.1)) continue;
            double aRadians = Math.toRadians(angle);
            double newCenterX = x * Math.cos(aRadians) - y * Math.sin(aRadians);
            double newCenterY = y * Math.cos(aRadians) + x * Math.sin(aRadians);
            a.setLocation((newCenterX += centerX) - bounds.getWidth() / 2.0, (newCenterY += centerY) - bounds.getHeight() / 2.0);
        }
        this.updateBounds();
    }

    @Override
    public void paint(Graphics g, boolean showSelected) {
        super.paint(g, showSelected);
        this.updateBounds();
    }

    private void updateBounds() {
        RectangularShape union = null;
        for (DingAnnotation child : this.annotations) {
            if (union == null) {
                union = child.getBounds().getBounds2D();
                continue;
            }
            union = ((Rectangle2D)union).createUnion(child.getBounds().getBounds2D());
        }
        if (union != null) {
            this.setBounds(union.getBounds());
        }
    }

    private Point2D getCenter(Rectangle2D bounds) {
        return new Point2D.Double(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
    }
}

