/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator.annotations;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Map;
import java.util.Objects;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.annotations.ShapeAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;

public class BoundedTextAnnotationImpl
extends ShapeAnnotationImpl
implements BoundedTextAnnotation,
TextAnnotation {
    private static final String DEF_TEXT = "Text";
    private String text;
    private boolean shapeIsFit;
    protected float fontSize;
    protected float savedFontSize;
    protected Font font;
    protected int initialFontSize = 12;
    protected Color textColor = Color.BLACK;
    private boolean updateNameFromText = true;

    public BoundedTextAnnotationImpl(DRenderingEngine re, boolean usedForPreviews) {
        super(re, 100.0, 100.0, usedForPreviews);
        this.font = new Font("Arial", 0, this.initialFontSize);
        this.fontSize = this.initialFontSize;
        this.text = DEF_TEXT;
        super.setSize(this.getTextWidth() + 4.0, this.getTextHeight() + 4.0);
    }

    public BoundedTextAnnotationImpl(DRenderingEngine re, double width, double height) {
        super(re, width, height, false);
        this.font = new Font("Arial", 0, this.initialFontSize);
        this.fontSize = this.initialFontSize;
        this.text = DEF_TEXT;
    }

    public BoundedTextAnnotationImpl(BoundedTextAnnotationImpl c) {
        super(c, 100.0, 100.0, false);
        this.text = c.getText();
        this.textColor = c.getTextColor();
        this.fontSize = (float)c.getFontSize();
        this.font = c.getFont();
    }

    public BoundedTextAnnotationImpl(DRenderingEngine re, double x, double y, double rotation, ShapeAnnotation.ShapeType shapeType, double width, double height, Paint fillColor, Paint edgeColor, float edgeThickness, String text, int compCount, double zoom) {
        super(re, x, y, rotation, shapeType, width, height, fillColor, edgeColor, edgeThickness);
        this.text = text;
        this.font = new Font("Arial", 0, this.initialFontSize);
        this.fontSize = this.initialFontSize;
    }

    public BoundedTextAnnotationImpl(DRenderingEngine re, Map<String, String> argMap) {
        super(re, argMap);
        this.font = ViewUtils.getArgFont(argMap, "Arial", 0, this.initialFontSize);
        double zoom = BoundedTextAnnotationImpl.getLegacyZoom(argMap);
        if (zoom != 1.0) {
            this.font = this.font.deriveFont(this.font.getSize2D() / (float)zoom);
        }
        this.textColor = (Color)ViewUtils.getColor(argMap, "color", Color.BLACK);
        this.text = ViewUtils.getString(argMap, "text", "");
        this.fontSize = this.font.getSize();
        if (argMap.containsKey("name")) {
            this.name = ViewUtils.getString(argMap, "name", "");
        } else if (this.text != null && !this.text.trim().isEmpty()) {
            this.name = this.text.trim();
        }
        if (!argMap.containsKey("width")) {
            double width = this.getTextWidth() + 8.0;
            double height = this.getTextHeight() + 8.0;
            super.setSize(width, height);
        }
    }

    @Override
    public void setName(String name) {
        if (name != null && !name.isEmpty()) {
            this.updateNameFromText = false;
        }
        super.setName(name);
    }

    @Override
    public Class<? extends Annotation> getType() {
        return BoundedTextAnnotation.class;
    }

    @Override
    public Map<String, String> getArgMap() {
        Map<String, String> argMap = super.getArgMap();
        argMap.put("type", BoundedTextAnnotation.class.getName());
        argMap.put("text", this.text);
        argMap.put("color", ViewUtils.convertColor(this.textColor));
        argMap.put("fontFamily", this.font.getFamily());
        argMap.put("fontSize", Integer.toString(this.font.getSize()));
        argMap.put("fontStyle", Integer.toString(this.font.getStyle()));
        return argMap;
    }

    @Override
    public void setStyle(Map<String, String> argMap) {
        super.setStyle(argMap);
        if (argMap != null) {
            this.setTextColor((Color)ViewUtils.getColor(argMap, "color", Color.BLACK));
            Font newFont = ViewUtils.getArgFont(argMap, this.font.getFamily(), this.font.getStyle(), this.font.getSize());
            double zoom = BoundedTextAnnotationImpl.getLegacyZoom(argMap);
            if (zoom != 1.0) {
                newFont = newFont.deriveFont(newFont.getSize2D() / (float)zoom);
            }
            this.setFont(newFont);
        }
    }

    public void fitShapeToText() {
        double width = this.getTextWidth() + 8.0;
        double height = this.getTextHeight() + 8.0;
        this.shapeIsFit = true;
        ShapeAnnotation.ShapeType shapeType = this.getShapeTypeEnum();
        switch (shapeType) {
            case ELLIPSE: {
                width = this.getTextWidth() * 3.0 / 2.0 + 8.0;
                height = this.getTextHeight() * 2.0;
                break;
            }
            case TRIANGLE: {
                width = this.getTextWidth() * 3.0 / 2.0 + 8.0;
                height = this.getTextHeight() * 2.0;
                break;
            }
            case PENTAGON: 
            case HEXAGON: 
            case STAR5: 
            case STAR6: {
                height = width = this.getTextWidth() * 9.0 / 7.0 + 8.0;
            }
        }
        super.setSize(width, height);
        this.setSize((int)width + 2, (int)height + 2);
    }

    @Override
    public void paint(Graphics g, boolean showSelection) {
        super.paint(g, showSelection);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.textColor);
        g2.setFont(this.font);
        int alpha = this.textColor.getAlpha();
        float opacity = (float)alpha / 255.0f;
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, opacity));
        int halfWidth = (int)(this.getWidth() - this.getTextWidth()) / 2;
        int halfHeight = (int)(this.getHeight() + this.getTextHeight() / 2.0) / 2;
        AffineTransform currentTransform = g2.getTransform();
        if (this.rotation != 0.0) {
            g2.rotate(Math.toRadians(this.rotation), (int)(this.getX() + this.getWidth() / 2.0), (int)(this.getY() + this.getHeight() / 2.0));
            g2.setClip(this.getBounds());
            g2.drawString(this.text, (int)this.getX() + halfWidth, (int)this.getY() + halfHeight);
            g2.setTransform(currentTransform);
        } else {
            g2.setClip(this.getBounds());
            g2.drawString(this.text, (int)this.getX() + halfWidth, (int)this.getY() + halfHeight);
        }
        g2.setComposite(originalComposite);
    }

    public void setText(String text) {
        if (!Objects.equals(text, this.text)) {
            String oldValue = this.text;
            this.text = text;
            if (this.updateNameFromText) {
                String string = this.name = text != null ? text.trim() : "";
            }
            if (this.shapeIsFit) {
                this.fitShapeToText();
            }
            this.updateBounds();
            this.update();
            this.firePropertyChange("text", oldValue, text);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(Color color) {
        if (!Objects.equals(this.textColor, color)) {
            Color oldValue = this.textColor;
            this.textColor = color;
            this.update();
            this.firePropertyChange("textColor", oldValue, this.textColor);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setFontSize(double size) {
        this.setFontSize(size, true);
    }

    public void setFontSize(double size, boolean updateBounds) {
        if (this.fontSize != (float)size) {
            float oldValue = this.fontSize;
            this.fontSize = (float)size;
            if (this.font != null) {
                this.font = this.font.deriveFont(this.fontSize);
            }
            if (updateBounds) {
                this.updateBounds();
            }
            this.update();
            this.firePropertyChange("fontSize", Float.valueOf(oldValue), Float.valueOf(this.fontSize));
        }
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setFontStyle(int style) {
        if (this.font == null || style != this.font.getStyle()) {
            int oldValue = this.font.getStyle();
            this.font = this.font.deriveFont(style, this.fontSize);
            this.update();
            this.firePropertyChange("fontStyle", oldValue, style);
        }
    }

    public int getFontStyle() {
        return this.font != null ? this.font.getStyle() : 0;
    }

    public void setFontFamily(String family) {
        if (family != null && !family.equalsIgnoreCase(this.getFontFamily())) {
            String oldValue = this.getFontFamily();
            this.font = new Font(family, this.getFontStyle(), (int)this.fontSize);
            this.update();
            this.firePropertyChange("fontFamily", oldValue, family);
        }
    }

    public String getFontFamily() {
        return this.font != null ? this.font.getFamily() : null;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (!Objects.equals(font, this.font)) {
            Font oldValue = this.font;
            this.font = font;
            this.fontSize = font.getSize2D();
            this.updateBounds();
            this.update();
            this.firePropertyChange("font", oldValue, font);
        }
    }

    @Override
    protected String getDefaultName() {
        return this.text != null ? this.text : DEF_TEXT;
    }

    private void updateBounds() {
        if (this.shapeIsFit) {
            this.fitShapeToText();
            return;
        }
        double xBound = Math.max(this.getTextWidth(), this.width);
        double yBound = Math.max(this.getTextHeight(), this.height);
        this.setSize(xBound + 4.0, yBound + 4.0);
    }

    double getTextWidth() {
        return this.font.getStringBounds(this.text, new FontRenderContext(null, true, true)).getWidth();
    }

    double getTextHeight() {
        return this.font.getStringBounds(this.text, new FontRenderContext(null, true, true)).getHeight();
    }

    Font getArgFont(Map<String, String> argMap) {
        String family = argMap.get("fontFamily");
        int size = Integer.parseInt(argMap.get("fontSize"));
        int style = Integer.parseInt(argMap.get("fontStyle"));
        return new Font(family, style, size);
    }
}

