/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.cyannotator;

import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.event.SwingPropertyChangeSupport;
import org.cytoscape.cg.event.CustomGraphicsLibraryUpdatedEvent;
import org.cytoscape.cg.event.CustomGraphicsLibraryUpdatedListener;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.cyannotator.AnnotationFactoryManager;
import org.cytoscape.ding.impl.cyannotator.AnnotationTree;
import org.cytoscape.ding.impl.cyannotator.IllegalAnnotationStructureException;
import org.cytoscape.ding.impl.cyannotator.annotations.AbstractAnnotation;
import org.cytoscape.ding.impl.cyannotator.annotations.AnnotationSelection;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.tasks.ReloadImagesTask;
import org.cytoscape.ding.impl.undo.AnnotationEdit;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyAnnotator
implements SessionAboutToBeSavedListener,
CustomGraphicsLibraryUpdatedListener {
    public static final String PROP_ANNOTATIONS = "annotations";
    public static final String PROP_REORDERED = "annotationsReordered";
    private static final String ANNOTATION_ATTRIBUTE = "__Annotations";
    private static final String DEF_ANNOTATION_NAME_PREFIX = "Annotation";
    private static final int MAX_NAME_LENGH = 200;
    private final DRenderingEngine re;
    private final AnnotationFactoryManager annotationFactoryManager;
    private final CyServiceRegistrar registrar;
    private final AnnotationSelection annotationSelection;
    private AbstractAnnotation resizing;
    private Rectangle2D resizeBounds;
    private ArrowAnnotationImpl repositioning;
    private Set<DingAnnotation> annotationSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private AnnotationEdit undoEdit;
    private final SwingPropertyChangeSupport propChangeSupport = new SwingPropertyChangeSupport(this);
    private boolean loading;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public CyAnnotator(DRenderingEngine re, AnnotationFactoryManager annotationFactoryManager, CyServiceRegistrar registrar) {
        this.re = re;
        this.registrar = registrar;
        this.annotationFactoryManager = annotationFactoryManager;
        this.annotationSelection = new AnnotationSelection(this);
    }

    public void handleEvent(CustomGraphicsLibraryUpdatedEvent evt) {
        TaskIterator iterator = new TaskIterator(new Task[]{new ReloadImagesTask(this)});
        ((TaskManager)this.registrar.getService(TaskManager.class)).execute(iterator);
    }

    public void markUndoEdit(String label) {
        this.undoEdit = new AnnotationEdit(label, this, this.registrar);
    }

    public void postUndoEdit() {
        if (this.undoEdit != null) {
            this.undoEdit.post();
        }
    }

    public void clearUndoEdit() {
        this.undoEdit = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void dispose() {
    }

    public boolean adjustBoundsToIncludeAnnotations(double[] extents) {
        List<DingAnnotation> annotations = this.getAnnotations();
        if (annotations.isEmpty()) {
            return false;
        }
        for (DingAnnotation a : annotations) {
            Rectangle2D bounds = a.getRotatedBounds();
            if (bounds.getX() < extents[0]) {
                extents[0] = bounds.getX();
            }
            if (bounds.getY() < extents[1]) {
                extents[1] = bounds.getY();
            }
            double x2 = bounds.getX() + bounds.getWidth();
            double y2 = bounds.getY() + bounds.getHeight();
            if (x2 > extents[2]) {
                extents[2] = x2;
            }
            if (!(y2 > extents[3])) continue;
            extents[3] = y2;
        }
        return true;
    }

    public void loadAnnotations() {
        CyNetwork network = (CyNetwork)this.re.getViewModel().getModel();
        CyTable networkAttributes = network.getTable(CyNetwork.class, "LOCAL_ATTRS");
        if (networkAttributes.getColumn(ANNOTATION_ATTRIBUTE) == null) {
            networkAttributes.createListColumn(ANNOTATION_ATTRIBUTE, String.class, false, Collections.emptyList());
        }
        List annotations = network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").getList(ANNOTATION_ATTRIBUTE, String.class);
        this.loadAnnotations(annotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAnnotations(List<String> annotations) {
        this.loading = true;
        try {
            ArrayList<Map<String, String>> arrowList = new ArrayList<Map<String, String>>();
            HashMap<GroupAnnotation, String> groupMap = new HashMap<GroupAnnotation, String>();
            HashMap<String, Annotation> uuidMap = new HashMap<String, Annotation>();
            HashMap<DingAnnotation.CanvasID, Map<Integer, DingAnnotation>> zOrderMap = new HashMap<DingAnnotation.CanvasID, Map<Integer, DingAnnotation>>();
            if (annotations != null) {
                this.loadRegularAnnotations(annotations, arrowList, groupMap, uuidMap, zOrderMap);
                this.loadGroups(groupMap, uuidMap);
                this.loadArrows(arrowList, zOrderMap);
                this.restoreZOrder(zOrderMap);
            }
        }
        catch (Exception e) {
            logger.error("Annotations were not loaded correctly.", (Throwable)e);
        }
        finally {
            this.loading = false;
            this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS, true);
            this.propChangeSupport.firePropertyChange(PROP_ANNOTATIONS, Collections.emptySet(), new HashSet<DingAnnotation>(this.annotationSet));
        }
    }

    public DingAnnotation getAnnotation(UUID annotationID) {
        for (DingAnnotation a : this.annotationSet) {
            if (!a.getUUID().equals(annotationID)) continue;
            return a;
        }
        return null;
    }

    public DRenderingEngine getRenderingEngine() {
        return this.re;
    }

    public CyServiceRegistrar getRegistrar() {
        return this.registrar;
    }

    public List<DingAnnotation> getAnnotations(DingAnnotation.CanvasID canvasId) {
        return this.getAnnotations(canvasId, true);
    }

    public boolean hasAnnotations(DingAnnotation.CanvasID canvasId) {
        for (DingAnnotation a : this.annotationSet) {
            if (a.getCanvas() != canvasId) continue;
            return true;
        }
        return false;
    }

    public List<DingAnnotation> getAnnotations(DingAnnotation.CanvasID canvasId, boolean ascending) {
        if (this.annotationSet.isEmpty()) {
            return Collections.emptyList();
        }
        Comparator<DingAnnotation> zComparator = Comparator.comparing(DingAnnotation::getZOrder);
        if (!ascending) {
            zComparator = zComparator.reversed();
        }
        return this.annotationSet.stream().filter(a -> a.getCanvas() == canvasId).sorted(zComparator).collect(Collectors.toList());
    }

    public AnnotationTree getAnnotationTree() {
        return AnnotationTree.buildTree(this.annotationSet, this);
    }

    public void checkCycle() throws IllegalAnnotationStructureException {
        if (AnnotationTree.containsCycle(this.annotationSet)) {
            throw new IllegalAnnotationStructureException("Adding annotation would create a cycle. Group annotations must be a tree.");
        }
    }

    public void checkCycle(Annotation annotation) throws IllegalAnnotationStructureException {
        if (annotation instanceof GroupAnnotation && AnnotationTree.containsCycle(this.annotationSet, (DingAnnotation)annotation)) {
            throw new IllegalAnnotationStructureException("Adding annotation would create a cycle. Group annotations must be a tree.");
        }
    }

    public void checkCycle(Collection<DingAnnotation> annotations) throws IllegalAnnotationStructureException {
        if (annotations.isEmpty()) {
            return;
        }
        if (AnnotationTree.containsCycle(this.annotationSet, annotations)) {
            throw new IllegalAnnotationStructureException("Adding annotation would create a cycle. Group annotations must be a tree.");
        }
    }

    public void addAnnotation(Annotation annotation) {
        if (this.annotationSet.contains(annotation)) {
            return;
        }
        if (!(annotation instanceof DingAnnotation)) {
            return;
        }
        HashSet<DingAnnotation> oldValue = new HashSet<DingAnnotation>(this.annotationSet);
        this.annotationSet.add((DingAnnotation)annotation);
        this.getAnnotationTree().resetZOrder();
        if (!this.loading) {
            this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS, true);
            this.propChangeSupport.firePropertyChange(PROP_ANNOTATIONS, oldValue, new HashSet<DingAnnotation>(this.annotationSet));
        }
    }

    public void addAnnotations(Collection<? extends Annotation> annotations) {
        if (this.annotationSet.containsAll(annotations)) {
            return;
        }
        HashSet<DingAnnotation> oldValue = new HashSet<DingAnnotation>(this.annotationSet);
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof DingAnnotation)) continue;
            this.annotationSet.add((DingAnnotation)annotation);
        }
        this.getAnnotationTree().resetZOrder();
        if (!this.loading) {
            this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS, true);
            this.propChangeSupport.firePropertyChange(PROP_ANNOTATIONS, oldValue, new HashSet<DingAnnotation>(this.annotationSet));
        }
    }

    public void removeAnnotation(Annotation annotation) {
        HashSet<DingAnnotation> oldValue = new HashSet<DingAnnotation>(this.annotationSet);
        boolean changed = this.annotationSet.remove((DingAnnotation)annotation);
        this.annotationSelection.remove(annotation);
        if (annotation.equals(this.repositioning)) {
            this.repositioning = null;
        }
        if (changed && !this.loading) {
            this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS, true);
            this.propChangeSupport.firePropertyChange(PROP_ANNOTATIONS, oldValue, new HashSet<DingAnnotation>(this.annotationSet));
        }
    }

    public void removeAnnotations(Collection<? extends Annotation> annotations) {
        boolean changed = false;
        HashSet<DingAnnotation> oldValue = new HashSet<DingAnnotation>(this.annotationSet);
        for (Annotation annotation : annotations) {
            if (this.annotationSet.remove((DingAnnotation)annotation)) {
                changed = true;
            }
            if (annotation.equals(this.repositioning)) {
                this.repositioning = null;
            }
            this.annotationSelection.remove(annotation);
        }
        if (changed && !this.loading) {
            this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS, true);
            this.propChangeSupport.firePropertyChange(PROP_ANNOTATIONS, oldValue, new HashSet<DingAnnotation>(this.annotationSet));
        }
    }

    public List<DingAnnotation> getAnnotations() {
        return this.annotationSet.isEmpty() ? Collections.emptyList() : new ArrayList<DingAnnotation>(this.annotationSet);
    }

    public boolean contains(Annotation a) {
        return a == null ? false : this.annotationSet.contains(a);
    }

    public void setSelectedAnnotation(DingAnnotation a, boolean selected) {
        if (selected) {
            this.annotationSelection.add(a);
        } else {
            this.annotationSelection.remove(a);
        }
    }

    public void clearSelectedAnnotations() {
        if (this.annotationSelection.isEmpty()) {
            return;
        }
        this.annotationSelection.getSelectedAnnotations().forEach(a -> a.setSelected(false));
        this.annotationSelection.clear();
    }

    public AnnotationSelection getAnnotationSelection() {
        return this.annotationSelection;
    }

    public void resizeShape(AbstractAnnotation shape) {
        if (shape == null) {
            this.resizing = null;
            this.resizeBounds = null;
        } else {
            this.resizing = shape;
            this.resizeBounds = shape.getBounds();
        }
    }

    public AbstractAnnotation getResizeShape() {
        return this.resizing;
    }

    public Rectangle2D getResizeBounds() {
        return this.resizeBounds;
    }

    public void positionArrow(ArrowAnnotationImpl arrow) {
        this.repositioning = arrow;
    }

    public ArrowAnnotationImpl getRepositioningArrow() {
        return this.repositioning;
    }

    public String getDefaultAnnotationName(String desiredName) {
        if (desiredName == null || "".equals(desiredName.trim())) {
            desiredName = DEF_ANNOTATION_NAME_PREFIX;
        }
        Pattern p = Pattern.compile(".*\\s(\\d*)$");
        Matcher m = p.matcher(desiredName);
        int start = 1;
        if (m.matches()) {
            desiredName = desiredName.substring(0, m.start(1) - 1);
            String gr = m.group(1);
            int n = start = gr.isEmpty() ? 1 : Integer.decode(gr) + 1;
        }
        if (desiredName.length() > 200) {
            desiredName = desiredName.substring(0, 200);
        }
        int i = start;
        String candidate;
        while (this.isAnnotationNameTaken(candidate = desiredName + " " + i)) {
            ++i;
        }
        return candidate;
    }

    private boolean isAnnotationNameTaken(String candidate) {
        for (DingAnnotation a : this.getAnnotations()) {
            String name = a.getName();
            if (name == null || !name.equals(candidate)) continue;
            return true;
        }
        return false;
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        CyNetwork network = (CyNetwork)this.re.getViewModel().getModel();
        List<String> networkAnnotation = this.createSavableNetworkAttribute();
        if (network.getDefaultNetworkTable().getColumn(ANNOTATION_ATTRIBUTE) == null) {
            network.getDefaultNetworkTable().createListColumn(ANNOTATION_ATTRIBUTE, String.class, false, Collections.emptyList());
        }
        network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").set(ANNOTATION_ATTRIBUTE, networkAnnotation);
    }

    public List<String> createSavableNetworkAttribute() {
        ArrayList<Map<String, String>> networkAnnotations = new ArrayList<Map<String, String>>();
        for (DingAnnotation annotation : this.annotationSet) {
            networkAnnotations.add(annotation.getArgMap());
        }
        return this.convertAnnotationMap(networkAnnotations);
    }

    private List<String> convertAnnotationMap(List<Map<String, String>> networkAnnotations) {
        ArrayList<String> result = new ArrayList<String>();
        if (networkAnnotations == null || networkAnnotations.size() == 0) {
            return result;
        }
        for (Map<String, String> map : networkAnnotations) {
            Map.Entry<String, String> entry;
            StringBuilder props = new StringBuilder();
            Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
            if (iter.hasNext()) {
                entry = iter.next();
                props.append(entry.getKey()).append('=').append(entry.getValue());
            }
            while (iter.hasNext()) {
                entry = iter.next();
                props.append('|').append(entry.getKey()).append('=').append(entry.getValue());
            }
            result.add(props.toString());
        }
        return result;
    }

    public void fireAnnotationsReordered() {
        this.propChangeSupport.firePropertyChange(PROP_REORDERED, null, null);
    }

    public void fireAnnotations() {
        this.propChangeSupport.firePropertyChange(PROP_ANNOTATIONS, null, null);
    }

    private void loadRegularAnnotations(List<String> annotations, List<Map<String, String>> arrowList, Map<GroupAnnotation, String> groupMap, Map<String, Annotation> uuidMap, Map<DingAnnotation.CanvasID, Map<Integer, DingAnnotation>> zOrderMap) {
        for (String s : annotations) {
            int zOrder;
            Map<String, String> argMap = this.createArgMap(s);
            DingAnnotation annotation = null;
            String type = argMap.get("type");
            if (type == null) continue;
            if (type.equals("ARROW") || type.equals("org.cytoscape.view.presentation.annotations.ArrowAnnotation")) {
                arrowList.add(argMap);
                continue;
            }
            Annotation a = this.annotationFactoryManager.createAnnotation(type, this.re.getViewModel(), argMap);
            if (a == null || !(a instanceof DingAnnotation)) continue;
            annotation = (DingAnnotation)a;
            uuidMap.put(annotation.getUUID().toString(), annotation);
            DingAnnotation.CanvasID canvas = annotation.getCanvas() != null ? annotation.getCanvas() : DingAnnotation.CanvasID.FOREGROUND;
            if (argMap.containsKey("z") && (zOrder = Integer.parseInt(argMap.get("z"))) >= 0) {
                if (!zOrderMap.containsKey((Object)canvas)) {
                    zOrderMap.put(canvas, new TreeMap());
                }
                zOrderMap.get((Object)canvas).put(zOrder, annotation);
            }
            this.addAnnotation(annotation);
            if (!type.equals("GROUP") && !type.equals("org.cytoscape.view.presentation.annotations.GroupAnnotation") || !argMap.containsKey("memberUUIDs")) continue;
            groupMap.put((GroupAnnotation)a, argMap.get("memberUUIDs"));
        }
    }

    private void loadGroups(Map<GroupAnnotation, String> groupMap, Map<String, Annotation> uuidMap) {
        for (GroupAnnotation group : groupMap.keySet()) {
            String[] uuidArray;
            String uuids = groupMap.get(group);
            for (String uuid : uuidArray = uuids.split(",")) {
                if (!uuidMap.containsKey(uuid)) continue;
                Annotation annotation = uuidMap.get(uuid);
                group.addMember(annotation);
            }
        }
    }

    private void loadArrows(List<Map<String, String>> arrowList, Map<DingAnnotation.CanvasID, Map<Integer, DingAnnotation>> zOrderMap) {
        for (Map<String, String> argMap : arrowList) {
            int zOrder;
            String type = argMap.get("type");
            Annotation annotation = this.annotationFactoryManager.createAnnotation(type, this.re.getViewModel(), argMap);
            if (!(annotation instanceof ArrowAnnotationImpl)) continue;
            ArrowAnnotationImpl arrow = (ArrowAnnotationImpl)annotation;
            arrow.getSource().addArrow((ArrowAnnotation)arrow);
            DingAnnotation.CanvasID canvas = arrow.getCanvas() != null ? arrow.getCanvas() : DingAnnotation.CanvasID.FOREGROUND;
            if (argMap.containsKey("z") && (zOrder = Integer.parseInt(argMap.get("z"))) >= 0) {
                if (!zOrderMap.containsKey((Object)canvas)) {
                    zOrderMap.put(canvas, new TreeMap());
                }
                zOrderMap.get((Object)canvas).put(zOrder, arrow);
            }
            this.addAnnotation(arrow);
        }
    }

    private void restoreZOrder(Map<DingAnnotation.CanvasID, Map<Integer, DingAnnotation>> zOrderMap) {
        for (Map<Integer, DingAnnotation> map : zOrderMap.values()) {
            for (Integer zOrder : map.keySet()) {
                DingAnnotation annotation = map.get(zOrder);
                if (annotation.getCanvas() == null) continue;
                annotation.setZOrder(zOrder);
            }
        }
    }

    private Map<String, String> createArgMap(String mapstring) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] argList = mapstring.split("[|]");
        if (argList.length == 0) {
            return result;
        }
        for (int argIndex = 0; argIndex < argList.length; ++argIndex) {
            String arg = argList[argIndex];
            String[] keyValue = arg.split("=");
            if (keyValue.length != 2) continue;
            result.put(keyValue[0], keyValue[1]);
        }
        return result;
    }
}

