/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl.canvas;

import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.DingCanvas;
import org.cytoscape.ding.impl.canvas.GraphicsProvider;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.graph.render.immed.GraphGraphics;
import org.cytoscape.graph.render.stateful.EdgeDetails;
import org.cytoscape.graph.render.stateful.GraphRenderer;
import org.cytoscape.graph.render.stateful.LabelInfoProvider;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.view.model.CyNetworkViewSnapshot;

public class EdgeCanvas<GP extends GraphicsProvider>
extends DingCanvas<GP> {
    private final DRenderingEngine re;
    private final GraphGraphics graphGraphics;

    public EdgeCanvas(GP graphics, DRenderingEngine re) {
        super(graphics);
        this.re = re;
        this.graphGraphics = new GraphGraphics((GraphicsProvider)graphics);
    }

    @Override
    public String getCanvasDebugName() {
        return "Edges";
    }

    @Override
    public void paint(ProgressMonitor pm, RenderDetailFlags flags) {
        CyNetworkViewSnapshot netViewSnapshot = this.re.getViewModelSnapshot();
        EdgeDetails edgeDetails = this.re.getEdgeDetails();
        NodeDetails nodeDetails = this.re.getNodeDetails();
        LabelInfoProvider labelProvider = flags.has(2048) ? this.re.getLabelCache() : LabelInfoProvider.NO_CACHE;
        this.graphGraphics.update(flags, true);
        GraphRenderer.renderEdges(pm, this.graphGraphics, netViewSnapshot, flags, nodeDetails, edgeDetails, labelProvider);
    }
}

