/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.geom.Point2D;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.cytoscape.ding.impl.NamedTaskFactory;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.task.EdgeViewTaskFactory;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.NodeViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.Togglable;

public class StaticTaskFactoryProvisioner {
    public NamedTaskFactory createFor(NetworkViewTaskFactory factory, CyNetworkView networkView) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, networkView) : new DynamicTaskFactory(factory, networkView);
    }

    public NamedTaskFactory createFor(NetworkViewLocationTaskFactory factory, CyNetworkView networkView, Point2D point, Point2D transformedPoint) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, networkView, point, transformedPoint) : new DynamicTaskFactory(factory, networkView, point, transformedPoint);
    }

    public NamedTaskFactory createFor(NodeViewTaskFactory factory, View<CyNode> nodeView, CyNetworkView networkView) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, nodeView, networkView) : new DynamicTaskFactory(factory, nodeView, networkView);
    }

    public NamedTaskFactory createFor(EdgeViewTaskFactory factory, View<CyEdge> edgeView, CyNetworkView networkView) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, edgeView, networkView) : new DynamicTaskFactory(factory, edgeView, networkView);
    }

    private class DynamicTogglableTaskFactory
    extends DynamicTaskFactory
    implements Togglable {
        DynamicTogglableTaskFactory(NetworkViewTaskFactory factory, CyNetworkView networkView) {
            super(factory, networkView);
        }

        DynamicTogglableTaskFactory(NetworkViewLocationTaskFactory factory, CyNetworkView networkView, Point2D point, Point2D transformedPoint) {
            super(factory, networkView, point, transformedPoint);
        }

        DynamicTogglableTaskFactory(NodeViewTaskFactory factory, View<CyNode> nodeView, CyNetworkView networkView) {
            super(factory, nodeView, networkView);
        }

        DynamicTogglableTaskFactory(EdgeViewTaskFactory factory, View<CyEdge> edgeView, CyNetworkView networkView) {
            super(factory, edgeView, networkView);
        }

        public boolean isOn() {
            if (this.factory instanceof NetworkViewTaskFactory) {
                return ((NetworkViewTaskFactory)this.factory).isOn((CyNetworkView)this.netViewRef.get());
            }
            if (this.factory instanceof NetworkViewLocationTaskFactory) {
                return ((NetworkViewLocationTaskFactory)this.factory).isOn((CyNetworkView)this.netViewRef.get(), this.point, this.transformedPoint);
            }
            if (this.factory instanceof NodeViewTaskFactory) {
                return ((NodeViewTaskFactory)this.factory).isOn((View)this.nodeViewRef.get(), (CyNetworkView)this.netViewRef.get());
            }
            if (this.factory instanceof EdgeViewTaskFactory) {
                return ((EdgeViewTaskFactory)this.factory).isOn((View)this.edgeViewRef.get(), (CyNetworkView)this.netViewRef.get());
            }
            return false;
        }
    }

    private class DynamicTaskFactory
    implements NamedTaskFactory {
        protected final Object factory;
        protected Reference<CyNetworkView> netViewRef;
        protected Reference<View<CyNode>> nodeViewRef;
        protected Reference<View<CyEdge>> edgeViewRef;
        protected Point2D point;
        protected Point2D transformedPoint;

        DynamicTaskFactory(NetworkViewTaskFactory factory, CyNetworkView networkView) {
            this.factory = factory;
            this.netViewRef = new WeakReference<CyNetworkView>(networkView);
        }

        DynamicTaskFactory(NetworkViewLocationTaskFactory factory, CyNetworkView networkView, Point2D point, Point2D transformedPoint) {
            this.factory = factory;
            this.netViewRef = new WeakReference<CyNetworkView>(networkView);
            this.point = point;
            this.transformedPoint = transformedPoint;
        }

        DynamicTaskFactory(NodeViewTaskFactory factory, View<CyNode> nodeView, CyNetworkView networkView) {
            this.factory = factory;
            this.netViewRef = new WeakReference<CyNetworkView>(networkView);
            this.nodeViewRef = new WeakReference<View<CyNode>>(nodeView);
        }

        DynamicTaskFactory(EdgeViewTaskFactory factory, View<CyEdge> edgeView, CyNetworkView networkView) {
            this.factory = factory;
            this.netViewRef = new WeakReference<CyNetworkView>(networkView);
            this.edgeViewRef = new WeakReference<View<CyEdge>>(edgeView);
        }

        public TaskIterator createTaskIterator() {
            if (this.factory instanceof NetworkViewTaskFactory) {
                return ((NetworkViewTaskFactory)this.factory).createTaskIterator(this.netViewRef.get());
            }
            if (this.factory instanceof NetworkViewLocationTaskFactory) {
                return ((NetworkViewLocationTaskFactory)this.factory).createTaskIterator(this.netViewRef.get(), this.point, this.transformedPoint);
            }
            if (this.factory instanceof NodeViewTaskFactory) {
                return ((NodeViewTaskFactory)this.factory).createTaskIterator(this.nodeViewRef.get(), this.netViewRef.get());
            }
            if (this.factory instanceof EdgeViewTaskFactory) {
                return ((EdgeViewTaskFactory)this.factory).createTaskIterator(this.edgeViewRef.get(), this.netViewRef.get());
            }
            return new TaskIterator(new Task[0]);
        }

        public boolean isReady() {
            if (this.factory instanceof NetworkViewTaskFactory) {
                return ((NetworkViewTaskFactory)this.factory).isReady(this.netViewRef.get());
            }
            if (this.factory instanceof NetworkViewLocationTaskFactory) {
                return ((NetworkViewLocationTaskFactory)this.factory).isReady(this.netViewRef.get(), this.point, this.transformedPoint);
            }
            if (this.factory instanceof NodeViewTaskFactory) {
                return ((NodeViewTaskFactory)this.factory).isReady(this.nodeViewRef.get(), this.netViewRef.get());
            }
            if (this.factory instanceof EdgeViewTaskFactory) {
                return ((EdgeViewTaskFactory)this.factory).isReady(this.edgeViewRef.get(), this.netViewRef.get());
            }
            return false;
        }

        @Override
        public String getName() {
            return this.factory.getClass().getSimpleName();
        }
    }
}

