/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Objects;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.values.ObjectPosition;

public class LabelSelection {
    private final View<CyNode> node;
    private final ObjectPosition originalPosition;
    private final double originalAngleDeg;
    private boolean angleChanged = false;
    private double angleRad;
    private double offsetX;
    private double offsetY;
    private double labelAnchorX;
    private double labelAnchorY;
    private Shape shape;

    public LabelSelection(View<CyNode> node, Shape shape, ObjectPosition originalPosition, double labelAnchorX, double labelAnchorY, double angleDegress) {
        this.node = node;
        this.shape = shape;
        this.angleRad = Math.toRadians(angleDegress);
        this.originalAngleDeg = angleDegress;
        this.originalPosition = originalPosition;
        this.offsetX = originalPosition.getOffsetX();
        this.offsetY = originalPosition.getOffsetY();
        this.labelAnchorX = labelAnchorX;
        this.labelAnchorY = labelAnchorY;
    }

    public View<CyNode> getNode() {
        return this.node;
    }

    public Shape getShape() {
        return this.shape;
    }

    public double getOriginalAngleDegrees() {
        return this.originalAngleDeg;
    }

    public double getAngleDegrees() {
        return this.angleChanged ? Math.toDegrees(this.angleRad) : this.originalAngleDeg;
    }

    public ObjectPosition getOriginalPosition() {
        return this.originalPosition;
    }

    public ObjectPosition getPosition() {
        ObjectPosition op = new ObjectPosition(this.originalPosition);
        op.setOffsetX(this.offsetX);
        op.setOffsetY(this.offsetY);
        return op;
    }

    public void translate(double dx, double dy) {
        AffineTransform t = AffineTransform.getTranslateInstance(dx, dy);
        this.shape = t.createTransformedShape(this.shape);
        this.labelAnchorX += dx;
        this.labelAnchorY += dy;
        this.offsetX += dx;
        this.offsetY += dy;
    }

    public void rotate(double rads) {
        AffineTransform t = AffineTransform.getRotateInstance(rads, this.labelAnchorX, this.labelAnchorY);
        this.shape = t.createTransformedShape(this.shape);
        this.angleRad += rads;
        this.angleChanged = true;
    }

    public double getAnchorX() {
        return this.labelAnchorX;
    }

    public double getAnchorY() {
        return this.labelAnchorY;
    }

    public boolean equals(Object other) {
        if (other instanceof LabelSelection) {
            return Objects.equals(((LabelSelection)other).node.getSUID(), this.node.getSUID());
        }
        return false;
    }

    public int hashCode() {
        return this.node.getSUID().hashCode();
    }
}

