/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolTip;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.impl.AddEdgeTask;
import org.cytoscape.ding.impl.BendStore;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.ding.impl.HandleInfo;
import org.cytoscape.ding.impl.LabelSelection;
import org.cytoscape.ding.impl.LabelSelectionManager;
import org.cytoscape.ding.impl.NetworkPicker;
import org.cytoscape.ding.impl.PopupMenuHelper;
import org.cytoscape.ding.impl.cyannotator.CyAnnotator;
import org.cytoscape.ding.impl.cyannotator.annotations.AnchorLocation;
import org.cytoscape.ding.impl.cyannotator.annotations.AnnotationSelection;
import org.cytoscape.ding.impl.cyannotator.annotations.ArrowAnnotationImpl;
import org.cytoscape.ding.impl.cyannotator.annotations.DingAnnotation;
import org.cytoscape.ding.impl.cyannotator.create.AbstractDingAnnotationFactory;
import org.cytoscape.ding.impl.cyannotator.tasks.EditAnnotationTaskFactory;
import org.cytoscape.ding.impl.cyannotator.utils.ViewUtils;
import org.cytoscape.ding.impl.undo.AnnotationEdit;
import org.cytoscape.ding.impl.undo.CompositeCyEdit;
import org.cytoscape.ding.impl.undo.LabelEdit;
import org.cytoscape.ding.impl.undo.ViewChangeEdit;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.ding.internal.util.OrderedMouseAdapter;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.graph.render.stateful.NodeDetails;
import org.cytoscape.graph.render.stateful.RenderDetailFlags;
import org.cytoscape.model.CyDisposable;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkViewLocationTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.destroy.DeleteSelectedNodesAndEdgesTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextWrapToolTip;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class InputHandlerGlassPane
extends JComponent
implements CyDisposable {
    private static final int PROGRESS_BAR_TICKS = 1000;
    private final CyServiceRegistrar registrar;
    private final OrderedMouseAdapter orderedMouseAdapter;
    private final PopupMenuHelper popupMenuHelper;
    private final JProgressBar progressBar;
    private DRenderingEngine re;
    private CyAnnotator cyAnnotator;

    public InputHandlerGlassPane(CyServiceRegistrar registrar, DRenderingEngine re) {
        this.registrar = registrar;
        this.re = re;
        this.cyAnnotator = re.getCyAnnotator();
        this.orderedMouseAdapter = new OrderedMouseAdapter(new FocusRequestListener(), new CanvasKeyListener(), new ContextMenuListener(), new DoubleClickListener(), new AddEdgeListener(), new TooltipListener(), new AddAnnotationListener(), new SelectionClickAndDragListener(), new SelectionRectangleListener(), new PanListener());
        this.addMouseListener(this.orderedMouseAdapter);
        this.addMouseMotionListener(this.orderedMouseAdapter);
        this.addKeyListener(this.orderedMouseAdapter.get(CanvasKeyListener.class));
        this.addMouseWheelListener(new CanvasMouseWheelListener());
        this.setFocusable(true);
        this.popupMenuHelper = new PopupMenuHelper(re, this, registrar);
        this.progressBar = this.addProgressBar();
    }

    public void dispose() {
        this.orderedMouseAdapter.dispose();
        this.re = null;
        this.cyAnnotator = null;
    }

    @Override
    public JToolTip createToolTip() {
        TextWrapToolTip tip = new TextWrapToolTip();
        tip.setMaximumSize(new Dimension(480, 320));
        tip.setComponent((JComponent)this);
        return tip;
    }

    private JProgressBar addProgressBar() {
        JProgressBar progressBar = new JProgressBar(0, 1000);
        Dimension size = progressBar.getPreferredSize();
        progressBar.setMaximumSize(new Dimension(100, size.height));
        progressBar.setVisible(false);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new FlowLayout(0));
        panel.add(progressBar);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "South");
        return progressBar;
    }

    public ProgressMonitor createProgressMonitor() {
        return new ProgressMonitor(){
            private boolean cancelled = false;
            private double currentProgress = 0.0;
            private Timer timer = new Timer(300, null);

            @Override
            public void start(String s) {
                InputHandlerGlassPane.this.progressBar.setValue(0);
                this.timer.setInitialDelay(300);
                this.timer.setRepeats(false);
                this.timer.addActionListener(e -> InputHandlerGlassPane.this.progressBar.setVisible(true));
                this.timer.start();
            }

            @Override
            public void done() {
                this.timer.stop();
                InputHandlerGlassPane.this.progressBar.setVisible(false);
                InputHandlerGlassPane.this.progressBar.setValue(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addProgress(double progress) {
                1 var3_2 = this;
                synchronized (var3_2) {
                    this.currentProgress += progress;
                }
                int ticks = (int)(this.currentProgress * 1000.0);
                InputHandlerGlassPane.this.progressBar.setValue(ticks);
            }

            @Override
            public void cancel() {
                this.cancelled = true;
                this.done();
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }
        };
    }

    private <T> T get(Class<T> t) {
        return this.orderedMouseAdapter.get(t);
    }

    private <T> Optional<T> maybe(Class<T> t) {
        return Optional.ofNullable(this.orderedMouseAdapter.get(t));
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.maybe(AddEdgeListener.class).ifPresent(l -> l.drawAddingEdge(g));
        this.maybe(SelectionRectangleListener.class).ifPresent(l -> l.drawSelectionRectangle(g));
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
    }

    public void beginAddingEdge(View<CyNode> nodeView) {
        this.get(AddEdgeListener.class).beginAddingEdge(nodeView);
    }

    public void beginClickToAddAnnotation(AnnotationFactory<? extends Annotation> factory, Runnable callback) {
        this.get(AddAnnotationListener.class).beginClickToAddAnnotation(factory, callback);
    }

    public void cancelClickToAddAnnotation(AnnotationFactory<? extends Annotation> factory) {
        AddAnnotationListener listener = this.get(AddAnnotationListener.class);
        if (listener != null && factory.equals(listener.getAnnotationFactory())) {
            listener.cancel();
        }
    }

    private boolean annotationSelectionEnabled() {
        return (Boolean)this.re.getViewModel().getVisualProperty(DVisualLexicon.NETWORK_ANNOTATION_SELECTION);
    }

    private boolean nodeSelectionEnabled() {
        return (Boolean)this.re.getViewModel().getVisualProperty(DVisualLexicon.NETWORK_NODE_SELECTION);
    }

    private boolean labelSelectionEnabled() {
        return (Boolean)this.re.getViewModel().getVisualProperty(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION);
    }

    private boolean edgeSelectionEnabled() {
        return !Boolean.FALSE.equals(this.re.getViewModel().getVisualProperty(DVisualLexicon.NETWORK_EDGE_SELECTION));
    }

    private boolean edgeCountIsLowEnoughToEnablePicking() {
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        GraphLOD fastLod = this.re.getGraphLOD().faster();
        GraphLOD.RenderEdges edges = RenderDetailFlags.renderEdges(snapshot, this.re.getTransform(), fastLod);
        return edges != GraphLOD.RenderEdges.NONE;
    }

    private boolean isLODEnabled(int flag) {
        return this.re.getPicker().getLastRenderDetail().has(flag);
    }

    private boolean overNode(Point2D mousePoint) {
        return this.re.getPicker().getNodeAt(mousePoint) != null;
    }

    private void changeCursor(Cursor cursor) {
        String componentName = "__CyNetworkView_" + this.re.getViewModel().getSUID();
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            if (!componentName.equals(parent.getName())) continue;
            parent.setCursor(cursor);
            break;
        }
    }

    private <T extends CyIdentifiable> void toggleSelection(View<T> element, Class<T> type, Toggle toggle) {
        if (element != null) {
            if (toggle == Toggle.SELECT) {
                this.select(Collections.singletonList(element), type, true);
            } else if (toggle == Toggle.DESELECT) {
                this.select(Collections.singletonList(element), type, false);
            }
        }
    }

    private boolean deselectAllNodes() {
        CyTable table = ((CyNetwork)this.re.getViewModel().getModel()).getDefaultNodeTable();
        Collection rows = table.getMatchingRows("selected", (Object)true);
        if (rows.isEmpty()) {
            return false;
        }
        this.batchDeselectRows(table, rows);
        return true;
    }

    private boolean deselectAllEdges() {
        this.re.getBendStore().unselectAllHandles();
        CyTable table = ((CyNetwork)this.re.getViewModel().getModel()).getDefaultEdgeTable();
        Collection rows = table.getMatchingRows("selected", (Object)true);
        if (rows.isEmpty()) {
            return false;
        }
        this.batchDeselectRows(table, rows);
        return true;
    }

    private void batchDeselectRows(CyTable table, Collection<CyRow> rows) {
        CyEventHelper eventHelper = (CyEventHelper)this.registrar.getService(CyEventHelper.class);
        eventHelper.silenceEventSource((Object)table);
        ArrayList<RowSetRecord> rowsChanged = new ArrayList<RowSetRecord>();
        for (CyRow row : rows) {
            if (row == null) continue;
            row.set("selected", (Object)false);
            rowsChanged.add(new RowSetRecord(row, "selected", (Object)false, (Object)false));
        }
        eventHelper.unsilenceEventSource((Object)table);
        RowsSetEvent event = new RowsSetEvent(table, rowsChanged);
        eventHelper.fireEvent((CyEvent)event);
    }

    private boolean deselectAllAnnotations() {
        if (!this.cyAnnotator.getAnnotationSelection().isEmpty()) {
            this.cyAnnotator.clearSelectedAnnotations();
            return true;
        }
        return false;
    }

    private void deselectAll() {
        boolean nodesDeselected = this.deselectAllNodes();
        boolean edgesDeselected = this.deselectAllEdges();
        boolean annotDeselected = this.deselectAllAnnotations();
        if (!nodesDeselected && !edgesDeselected && annotDeselected) {
            this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
        }
    }

    private Cursor createRotateCursor() {
        Dimension size = Toolkit.getDefaultToolkit().getBestCursorSize(256, 256);
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = ((Image)image).getGraphics();
        String icon = "\uf01e";
        JLabel label = new JLabel(icon);
        label.setBounds(0, 0, size.width, size.height);
        label.setFont(((IconManager)this.registrar.getService(IconManager.class)).getIconFont(150.0f));
        label.paint(graphics);
        graphics.dispose();
        Image newImage = image.getScaledInstance(24, 24, 1);
        return Toolkit.getDefaultToolkit().createCustomCursor(newImage, new Point(0, 0), "custom:" + icon.charAt(0));
    }

    private <T extends CyIdentifiable> void select(Collection<View<T>> nodesOrEdgeViews, Class<T> type, boolean selected) {
        if (nodesOrEdgeViews == null || nodesOrEdgeViews.isEmpty()) {
            return;
        }
        boolean isNodes = type.equals(CyNode.class);
        Boolean selectedBoxed = selected;
        CyNetwork model = (CyNetwork)this.re.getViewModel().getModel();
        CyTable table = isNodes ? model.getDefaultNodeTable() : model.getDefaultEdgeTable();
        CyNetworkViewSnapshot snapshot = this.re.getViewModelSnapshot();
        for (View<T> nodeOrEdgeView : nodesOrEdgeViews) {
            CyRow row;
            Long modelSuid;
            if (isNodes) {
                View mutableNodeView = snapshot.getMutableNodeView(nodeOrEdgeView.getSUID().longValue());
                modelSuid = snapshot.getNodeInfo(nodeOrEdgeView).getModelSUID();
                row = table.getRow((Object)modelSuid);
                mutableNodeView.setVisualProperty(BasicVisualLexicon.NODE_SELECTED, (Object)selectedBoxed);
                row.set("selected", (Object)selectedBoxed);
                continue;
            }
            View mutableEdgeView = snapshot.getMutableEdgeView(nodeOrEdgeView.getSUID().longValue());
            modelSuid = snapshot.getEdgeInfo(nodeOrEdgeView).getModelSUID();
            row = table.getRow((Object)modelSuid);
            mutableEdgeView.setVisualProperty(BasicVisualLexicon.EDGE_SELECTED, (Object)selectedBoxed);
            row.set("selected", (Object)selectedBoxed);
        }
    }

    private static enum Toggle {
        SELECT,
        DESELECT,
        NOCHANGE;

    }

    private class PanListener
    extends MouseAdapter {
        private final double[] coords = new double[2];
        private final Cursor panCursor = this.createPanCursor();
        private Point mousePressedPoint;
        private ViewChangeEdit undoPanEdit;
        private DRenderingEngine.Panner panner = null;

        private PanListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ViewUtil.isSingleLeftClick(e)) {
                return;
            }
            this.panner = InputHandlerGlassPane.this.re.startPan();
            InputHandlerGlassPane.this.changeCursor(this.panCursor);
            this.mousePressedPoint = e.getPoint();
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mousePressedPoint != null) {
                if (this.undoPanEdit == null) {
                    this.undoPanEdit = new ViewChangeEdit(InputHandlerGlassPane.this.re, null, "Pan", InputHandlerGlassPane.this.registrar);
                }
                this.coords[0] = this.mousePressedPoint.getX();
                this.coords[1] = this.mousePressedPoint.getY();
                InputHandlerGlassPane.this.re.getTransform().xformImageToNodeCoords(this.coords);
                double oldX = this.coords[0];
                double oldY = this.coords[1];
                this.coords[0] = e.getX();
                this.coords[1] = e.getY();
                InputHandlerGlassPane.this.re.getTransform().xformImageToNodeCoords(this.coords);
                double newX = this.coords[0];
                double newY = this.coords[1];
                this.mousePressedPoint = e.getPoint();
                double deltaX = oldX - newX;
                double deltaY = oldY - newY;
                this.panner.continuePan(deltaX, deltaY);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.undoPanEdit != null) {
                this.undoPanEdit.post();
            }
            InputHandlerGlassPane.this.changeCursor(Cursor.getPredefinedCursor(0));
            this.mousePressedPoint = null;
            this.undoPanEdit = null;
            if (this.panner != null) {
                this.panner.endPan();
                this.panner = null;
            }
        }

        private Cursor createPanCursor() {
            if (LookAndFeelUtil.isMac()) {
                Dimension size = Toolkit.getDefaultToolkit().getBestCursorSize(24, 24);
                BufferedImage image = new BufferedImage(size.width, size.height, 2);
                Graphics graphics = ((Image)image).getGraphics();
                String icon = "\uf047";
                JLabel label = new JLabel(icon);
                label.setBounds(0, 0, size.width, size.height);
                label.setFont(((IconManager)InputHandlerGlassPane.this.registrar.getService(IconManager.class)).getIconFont(14.0f));
                label.paint(graphics);
                graphics.dispose();
                return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "custom:" + icon.charAt(0));
            }
            Cursor panCursor = Cursor.getPredefinedCursor(13);
            if (panCursor == null) {
                panCursor = new Cursor(13);
            }
            return panCursor;
        }
    }

    private class SelectionRectangleListener
    extends MouseAdapter {
        private final Color SELECTION_RECT_BORDER_COLOR_1 = UIManager.getColor("Focus.color");
        private final Color SELECTION_RECT_BORDER_COLOR_2 = new Color(255, 255, 255, 160);
        private Rectangle selectionRect;
        private Point mousePressedPoint;

        private SelectionRectangleListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ViewUtil.isDragSelectionKeyDown(e)) {
                InputHandlerGlassPane.this.get(AddEdgeListener.class).reset();
                this.mousePressedPoint = e.getPoint();
                this.selectionRect = new Rectangle(e.getX(), e.getY(), 0, 0);
                InputHandlerGlassPane.this.changeCursor(Cursor.getPredefinedCursor(0));
                e.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.selectionRect != null) {
                int x = Math.min(this.mousePressedPoint.x, e.getX());
                int y = Math.min(this.mousePressedPoint.y, e.getY());
                int w = Math.abs(this.mousePressedPoint.x - e.getX());
                int h = Math.abs(this.mousePressedPoint.y - e.getY());
                this.selectionRect.setBounds(x, y, w, h);
                InputHandlerGlassPane.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.selectionRect != null) {
                List<Object> annotations = Collections.emptyList();
                List nodes = Collections.emptyList();
                List edges = Collections.emptyList();
                if (InputHandlerGlassPane.this.annotationSelectionEnabled()) {
                    annotations = InputHandlerGlassPane.this.re.getPicker().getAnnotationsInRectangle(this.selectionRect);
                }
                if (InputHandlerGlassPane.this.nodeSelectionEnabled()) {
                    nodes = InputHandlerGlassPane.this.re.getPicker().getNodesInRectangle(this.selectionRect);
                }
                if (InputHandlerGlassPane.this.edgeSelectionEnabled()) {
                    edges = InputHandlerGlassPane.this.re.getPicker().getEdgesInRectangle(this.selectionRect);
                }
                if (!nodes.isEmpty()) {
                    InputHandlerGlassPane.this.select(nodes, CyNode.class, true);
                }
                if (!edges.isEmpty()) {
                    InputHandlerGlassPane.this.select(edges, CyEdge.class, true);
                }
                for (DingAnnotation dingAnnotation : annotations) {
                    dingAnnotation.setSelected(true);
                }
                if (nodes.isEmpty() && edges.isEmpty() && !annotations.isEmpty()) {
                    InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
                }
            }
            this.selectionRect = null;
            this.mousePressedPoint = null;
            InputHandlerGlassPane.this.repaint();
        }

        public boolean isDragging() {
            return this.selectionRect != null;
        }

        public void drawSelectionRectangle(Graphics graphics) {
            if (this.selectionRect != null) {
                Graphics2D g = (Graphics2D)graphics.create();
                g.setColor(this.SELECTION_RECT_BORDER_COLOR_1);
                g.draw(this.selectionRect);
                if (this.selectionRect.width > 4 && this.selectionRect.height > 4) {
                    g.setColor(this.SELECTION_RECT_BORDER_COLOR_2);
                    g.drawRect(this.selectionRect.x + 1, this.selectionRect.y + 1, this.selectionRect.width - 2, this.selectionRect.height - 2);
                }
            }
        }
    }

    private class AddAnnotationListener
    extends MouseAdapter {
        private AnnotationFactory<?> annotationFactory;
        private Runnable callback;

        private AddAnnotationListener() {
        }

        public void beginClickToAddAnnotation(AnnotationFactory<? extends Annotation> factory, Runnable callback) {
            this.annotationFactory = factory;
            this.callback = callback;
            InputHandlerGlassPane.this.changeCursor(Cursor.getPredefinedCursor(1));
        }

        public AnnotationFactory<?> getAnnotationFactory() {
            return this.annotationFactory;
        }

        public void cancel() {
            if (this.annotationFactory != null) {
                InputHandlerGlassPane.this.cyAnnotator.fireAnnotations();
            }
            this.annotationFactory = null;
            this.callback = null;
            InputHandlerGlassPane.this.changeCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.annotationFactory != null && ViewUtil.isSingleLeftClick(e)) {
                this.createAnnotation(this.annotationFactory, e.getPoint());
                e.consume();
                if (this.callback != null) {
                    this.callback.run();
                }
            }
            this.annotationFactory = null;
            this.callback = null;
            InputHandlerGlassPane.this.changeCursor(Cursor.getPredefinedCursor(0));
        }

        private void createAnnotation(AnnotationFactory<? extends Annotation> f, Point point) {
            if (!(f instanceof AbstractDingAnnotationFactory)) {
                return;
            }
            String filter = "(id=addAnnotationTaskFactory_" + f.getId() + ")";
            NetworkViewLocationTaskFactory factory = (NetworkViewLocationTaskFactory)InputHandlerGlassPane.this.registrar.getService(NetworkViewLocationTaskFactory.class, filter);
            TaskIterator iterator = factory.createTaskIterator(InputHandlerGlassPane.this.re.getViewModel(), (Point2D)point, null);
            ((DialogTaskManager)InputHandlerGlassPane.this.registrar.getService(DialogTaskManager.class)).execute(iterator);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ArrowAnnotationImpl arrow = InputHandlerGlassPane.this.cyAnnotator.getRepositioningArrow();
            if (arrow != null) {
                Point mousePoint = e.getPoint();
                List<DingAnnotation> annotations = InputHandlerGlassPane.this.re.getPicker().getAnnotationsAt(mousePoint);
                if (annotations.contains(arrow)) {
                    annotations.remove(arrow);
                }
                if (!annotations.isEmpty()) {
                    arrow.setTarget(annotations.get(0));
                } else if (InputHandlerGlassPane.this.overNode(mousePoint)) {
                    View<CyNode> overNode = InputHandlerGlassPane.this.re.getPicker().getNodeAt(mousePoint);
                    View mutableNodeView = InputHandlerGlassPane.this.re.getViewModelSnapshot().getMutableNodeView(overNode.getSUID().longValue());
                    arrow.setTarget((View<? extends CyIdentifiable>)mutableNodeView);
                } else {
                    Point2D nodeCoordinates = InputHandlerGlassPane.this.re.getTransform().getNodeCoordinates(mousePoint);
                    arrow.setTarget(nodeCoordinates);
                }
                arrow.update();
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ArrowAnnotationImpl arrow = InputHandlerGlassPane.this.cyAnnotator.getRepositioningArrow();
            if (arrow != null && arrow.getTarget() != null) {
                arrow.contentChanged();
                InputHandlerGlassPane.this.cyAnnotator.clearSelectedAnnotations();
                ViewUtils.selectAnnotation(InputHandlerGlassPane.this.re, arrow);
                InputHandlerGlassPane.this.cyAnnotator.positionArrow(null);
                InputHandlerGlassPane.this.cyAnnotator.postUndoEdit();
            }
        }
    }

    private class SelectionClickAndDragListener
    extends MouseAdapter {
        private Point mousePressedPoint;
        private boolean deselectAllOnRelease;
        private boolean hit;
        private AnnotationEdit annotationResizeEdit;
        private AnnotationEdit annotationMovingEdit;
        private AnnotationEdit annotationRotateEdit;
        private ViewChangeEdit removeHandleEdit;
        private ViewChangeEdit addHandleEdit;
        private ViewChangeEdit moveNodesEdit;
        private CompositeCyEdit<LabelEdit> labelEdit;
        private final Cursor rotateCursor;

        private SelectionClickAndDragListener() {
            this.rotateCursor = InputHandlerGlassPane.this.createRotateCursor();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ViewUtil.isSingleLeftClick(e)) {
                return;
            }
            this.annotationResizeEdit = null;
            this.annotationMovingEdit = null;
            this.annotationRotateEdit = null;
            this.removeHandleEdit = null;
            this.addHandleEdit = null;
            this.moveNodesEdit = null;
            this.labelEdit = null;
            this.deselectAllOnRelease = false;
            this.mousePressedPoint = e.getPoint();
            this.hit = this.mousePressedCheckHit(e);
            if (this.hit) {
                e.consume();
            } else if (!ViewUtil.isAdditiveSelect(e)) {
                this.deselectAllOnRelease = true;
            }
        }

        private boolean mousePressedCheckHit(MouseEvent e) {
            DingAnnotation annotation;
            View<CyEdge> edge;
            HandleInfo handle;
            boolean selectEdges;
            View<CyNode> node;
            LabelSelection selectedLabel;
            NetworkPicker picker = InputHandlerGlassPane.this.re.getPicker();
            if (InputHandlerGlassPane.this.annotationSelectionEnabled()) {
                AnnotationSelection annotationSelection = InputHandlerGlassPane.this.cyAnnotator.getAnnotationSelection();
                annotationSelection.setMovingStartOffset(e.getPoint());
                AnchorLocation anchor = annotationSelection.overAnchor(e.getX(), e.getY());
                if (!annotationSelection.isEmpty() && anchor != null) {
                    if (ViewUtil.isControlOrMetaDown(e)) {
                        InputHandlerGlassPane.this.changeCursor(this.rotateCursor);
                        annotationSelection.setRotations();
                    } else {
                        this.mousePressedHandleAnnotationAnchor(anchor, e);
                    }
                    InputHandlerGlassPane.this.re.getLabelSelectionManager().clear();
                    return true;
                }
                DingAnnotation annotation2 = picker.getAnnotationAt(DingAnnotation.CanvasID.FOREGROUND, e.getPoint());
                if (annotation2 != null) {
                    Toggle select = this.mousePressedHandleAnnotation(annotation2, e);
                    if (select != Toggle.NOCHANGE && !ViewUtil.isAdditiveSelect(e)) {
                        InputHandlerGlassPane.this.deselectAllNodes();
                        InputHandlerGlassPane.this.deselectAllEdges();
                    }
                    annotationSelection.setMovingStartOffset(e.getPoint());
                    InputHandlerGlassPane.this.re.getLabelSelectionManager().clear();
                    return true;
                }
            }
            if (InputHandlerGlassPane.this.labelSelectionEnabled() && (selectedLabel = picker.getNodeLabelAt(e.getPoint())) != null) {
                LabelSelectionManager labelSelectionManager = InputHandlerGlassPane.this.re.getLabelSelectionManager();
                labelSelectionManager.setCurrentDragPoint(e.getPoint());
                if (ViewUtil.isControlOrMetaDown(e)) {
                    InputHandlerGlassPane.this.changeCursor(this.rotateCursor);
                }
                if (!labelSelectionManager.contains(selectedLabel)) {
                    if (!e.isShiftDown()) {
                        labelSelectionManager.clear();
                    }
                    labelSelectionManager.add(selectedLabel);
                }
                labelSelectionManager.setPrimary(selectedLabel);
                return true;
            }
            InputHandlerGlassPane.this.re.getLabelSelectionManager().clear();
            if (InputHandlerGlassPane.this.nodeSelectionEnabled() && (node = picker.getNodeAt(e.getPoint())) != null) {
                Toggle select = this.toggleNodeSelection(node, e);
                if (select != Toggle.NOCHANGE && !ViewUtil.isAdditiveSelect(e)) {
                    InputHandlerGlassPane.this.deselectAll();
                }
                InputHandlerGlassPane.this.toggleSelection(node, CyNode.class, select);
                return true;
            }
            boolean bl = selectEdges = InputHandlerGlassPane.this.edgeSelectionEnabled() && InputHandlerGlassPane.this.edgeCountIsLowEnoughToEnablePicking();
            if (selectEdges && InputHandlerGlassPane.this.isLODEnabled(64) && (handle = picker.getHandleAt(e.getPoint())) != null) {
                this.toggleChosenAnchor(handle, e);
                return true;
            }
            if (selectEdges && (edge = picker.getEdgeAt(e.getPoint())) != null) {
                Toggle select;
                if (e.isAltDown() && InputHandlerGlassPane.this.isLODEnabled(64)) {
                    this.addHandle(edge, e);
                }
                if ((select = this.toggleSelectedEdge(edge, e)) != Toggle.NOCHANGE && !ViewUtil.isAdditiveSelect(e)) {
                    InputHandlerGlassPane.this.deselectAll();
                }
                InputHandlerGlassPane.this.toggleSelection(edge, CyEdge.class, select);
                return true;
            }
            if (InputHandlerGlassPane.this.annotationSelectionEnabled() && (annotation = picker.getAnnotationAt(DingAnnotation.CanvasID.BACKGROUND, e.getPoint())) != null) {
                this.mousePressedHandleAnnotation(annotation, e);
                return true;
            }
            return false;
        }

        private void mousePressedHandleAnnotationAnchor(AnchorLocation anchor, MouseEvent e) {
            InputHandlerGlassPane.this.changeCursor(ViewUtil.getResizeCursor(anchor.getPosition()));
            AnnotationSelection annotationSelection = InputHandlerGlassPane.this.cyAnnotator.getAnnotationSelection();
            annotationSelection.startResizing(anchor);
        }

        private Toggle mousePressedHandleAnnotation(DingAnnotation annotation, MouseEvent e) {
            Toggle toggle = Toggle.NOCHANGE;
            boolean wasSelected = annotation.isSelected();
            if (wasSelected && ViewUtil.isAdditiveSelect(e)) {
                annotation.setSelected(false);
                toggle = Toggle.DESELECT;
            } else {
                if (!wasSelected && !ViewUtil.isAdditiveSelect(e)) {
                    InputHandlerGlassPane.this.cyAnnotator.clearSelectedAnnotations();
                }
                if (!wasSelected) {
                    annotation.setSelected(true);
                    toggle = Toggle.SELECT;
                }
            }
            if (toggle != Toggle.NOCHANGE) {
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
            }
            return toggle;
        }

        private Toggle toggleNodeSelection(View<CyNode> nodeView, MouseEvent e) {
            boolean wasSelected = InputHandlerGlassPane.this.re.getNodeDetails().isSelected(nodeView);
            if (wasSelected && ViewUtil.isAdditiveSelect(e)) {
                return Toggle.DESELECT;
            }
            if (!wasSelected) {
                return Toggle.SELECT;
            }
            return Toggle.NOCHANGE;
        }

        private void toggleChosenAnchor(HandleInfo chosenAnchor, MouseEvent e) {
            if (e.isAltDown()) {
                this.removeHandleEdit = new ViewChangeEdit(InputHandlerGlassPane.this.re, ViewChangeEdit.SavedObjs.SELECTED_EDGES, "Remove Edge Handle", InputHandlerGlassPane.this.registrar);
                InputHandlerGlassPane.this.re.getBendStore().removeHandle(chosenAnchor);
            } else {
                boolean selected = InputHandlerGlassPane.this.re.getBendStore().isHandleSelected(chosenAnchor);
                if (selected && (e.isShiftDown() || ViewUtil.isControlOrMetaDown(e) && !e.isAltDown())) {
                    InputHandlerGlassPane.this.re.getBendStore().unselectHandle(chosenAnchor);
                } else if (!selected) {
                    if (!(e.isShiftDown() || ViewUtil.isControlOrMetaDown(e) && !e.isAltDown())) {
                        InputHandlerGlassPane.this.re.getBendStore().unselectAllHandles();
                    }
                    InputHandlerGlassPane.this.re.getBendStore().selectHandle(chosenAnchor);
                }
            }
            InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL);
        }

        private Toggle toggleSelectedEdge(View<CyEdge> edgeView, MouseEvent e) {
            boolean wasSelected = InputHandlerGlassPane.this.re.getEdgeDetails().isSelected(edgeView);
            Toggle toggle = Toggle.NOCHANGE;
            if (wasSelected && (e.isShiftDown() || ViewUtil.isControlOrMetaDown(e) && !e.isAltDown())) {
                toggle = Toggle.DESELECT;
            } else if (!wasSelected) {
                HandleInfo hit;
                toggle = Toggle.SELECT;
                if (InputHandlerGlassPane.this.isLODEnabled(64) && (hit = InputHandlerGlassPane.this.re.getPicker().getHandleAt(e.getPoint())) != null) {
                    InputHandlerGlassPane.this.re.getBendStore().selectHandle(hit);
                }
            }
            InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL);
            return toggle;
        }

        private void addHandle(View<CyEdge> edgeView, MouseEvent e) {
            BendStore bendStore = InputHandlerGlassPane.this.re.getBendStore();
            bendStore.unselectAllHandles();
            this.addHandleEdit = new ViewChangeEdit(InputHandlerGlassPane.this.re, ViewChangeEdit.SavedObjs.SELECTED_EDGES, "Add Edge Handle", InputHandlerGlassPane.this.registrar);
            Point2D newHandlePoint = InputHandlerGlassPane.this.re.getTransform().getNodeCoordinates(e.getPoint());
            HandleInfo handle = bendStore.addHandle(edgeView, newHandlePoint);
            bendStore.selectHandle(handle);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.hit) {
                return;
            }
            this.hit = false;
            InputHandlerGlassPane.this.changeCursor(Cursor.getPredefinedCursor(0));
            if (!ViewUtil.isLeftClick(e)) {
                return;
            }
            LabelSelectionManager labelSelectionManager = InputHandlerGlassPane.this.re.getLabelSelectionManager();
            if (!labelSelectionManager.isEmpty()) {
                Collection<LabelSelection> selectedLabels = labelSelectionManager.getSelectedLabels();
                for (LabelSelection selectedLabel : selectedLabels) {
                    View mutableNode = InputHandlerGlassPane.this.re.getViewModelSnapshot().getMutableNodeView(selectedLabel.getNode().getSUID().longValue());
                    ObjectPosition newPosition = selectedLabel.getPosition();
                    double newAngle = selectedLabel.getAngleDegrees();
                    mutableNode.setLockedValue(DVisualLexicon.NODE_LABEL_POSITION, (Object)newPosition);
                    mutableNode.setLockedValue(DVisualLexicon.NODE_LABEL_ROTATION, (Object)newAngle);
                }
                if (this.labelEdit != null) {
                    this.labelEdit.getChildren().forEach(LabelEdit::savePositionAndAngle);
                    this.labelEdit.post();
                }
                this.mousePressedPoint = null;
                e.consume();
                return;
            }
            if (InputHandlerGlassPane.this.annotationSelectionEnabled()) {
                AnnotationSelection annotationSelection = InputHandlerGlassPane.this.cyAnnotator.getAnnotationSelection();
                annotationSelection.stopResizing();
                annotationSelection.stopMoving();
                annotationSelection.stopRotating();
            }
            this.mousePressedPoint = null;
            if (this.annotationMovingEdit != null || this.moveNodesEdit != null) {
                if (this.annotationMovingEdit != null) {
                    this.annotationMovingEdit.saveNewAnnotations();
                }
                if (this.moveNodesEdit != null) {
                    this.moveNodesEdit.saveNewPositions();
                }
                CompositeCyEdit<AnnotationEdit> composite = new CompositeCyEdit<AnnotationEdit>("Move", InputHandlerGlassPane.this.registrar, 2);
                composite.add(this.annotationMovingEdit).add((AnnotationEdit)((Object)this.moveNodesEdit));
                composite.post();
            } else if (this.annotationResizeEdit != null) {
                this.annotationResizeEdit.post();
            } else if (this.annotationRotateEdit != null) {
                this.annotationRotateEdit.post();
            } else if (this.removeHandleEdit != null) {
                this.removeHandleEdit.post();
            } else if (this.addHandleEdit != null) {
                this.addHandleEdit.post();
            }
            e.consume();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!ViewUtil.isSingleLeftClick(e)) {
                return;
            }
            if (this.deselectAllOnRelease) {
                InputHandlerGlassPane.this.re.getLabelSelectionManager().clear();
                InputHandlerGlassPane.this.deselectAll();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.hit || !ViewUtil.isLeftMouse(e)) {
                return;
            }
            if (InputHandlerGlassPane.this.get(SelectionRectangleListener.class).isDragging()) {
                return;
            }
            LabelSelectionManager labelSelectionManager = InputHandlerGlassPane.this.re.getLabelSelectionManager();
            if (!labelSelectionManager.isEmpty()) {
                if (this.labelEdit == null) {
                    Collection<LabelSelection> selectedLabels = labelSelectionManager.getSelectedLabels();
                    this.labelEdit = new CompositeCyEdit("Move Labels", InputHandlerGlassPane.this.registrar, selectedLabels.size());
                    for (LabelSelection selectedLabel : selectedLabels) {
                        View mutableNode = InputHandlerGlassPane.this.re.getViewModelSnapshot().getMutableNodeView(selectedLabel.getNode().getSUID().longValue());
                        Long suid = ((CyNode)mutableNode.getModel()).getSUID();
                        LabelEdit edit = new LabelEdit(InputHandlerGlassPane.this.registrar, InputHandlerGlassPane.this.re, InputHandlerGlassPane.this.re.getViewModel(), suid, selectedLabel);
                        this.labelEdit.add(edit);
                    }
                }
                if (ViewUtil.isControlOrMetaDown(e)) {
                    labelSelectionManager.rotate(e.getPoint());
                } else {
                    labelSelectionManager.move(e.getPoint());
                }
                labelSelectionManager.setCurrentDragPoint(e.getPoint());
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.ALL_FAST);
                return;
            }
            Collection selectedNodes = InputHandlerGlassPane.this.re.getViewModelSnapshot().getTrackedNodes(DingNetworkViewFactory.SELECTED_NODES);
            AnnotationSelection annotationSelection = InputHandlerGlassPane.this.cyAnnotator.getAnnotationSelection();
            if (!annotationSelection.isEmpty()) {
                if (annotationSelection.isResizing()) {
                    if (this.annotationResizeEdit == null) {
                        this.annotationResizeEdit = new AnnotationEdit("Resize Annotation", InputHandlerGlassPane.this.re);
                    }
                    annotationSelection.resizeAnnotationsRelative(e.getX(), e.getY(), e.isShiftDown());
                    InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
                    return;
                }
                if (annotationSelection.isRotating()) {
                    if (this.annotationRotateEdit == null) {
                        this.annotationRotateEdit = new AnnotationEdit("Rotate Annotation", InputHandlerGlassPane.this.re);
                    }
                    annotationSelection.rotateSelection(e.getPoint());
                } else {
                    if (this.annotationMovingEdit == null) {
                        this.annotationMovingEdit = new AnnotationEdit("Move Annotation", InputHandlerGlassPane.this.re);
                    }
                    annotationSelection.moveSelection(e.getPoint());
                    annotationSelection.setMovingStartOffset(e.getPoint());
                }
            }
            if (!selectedNodes.isEmpty() || InputHandlerGlassPane.this.re.getBendStore().areHandlesSelected()) {
                this.mouseDraggedHandleNodesAndEdges(selectedNodes, e);
            }
            if (!selectedNodes.isEmpty() || InputHandlerGlassPane.this.re.getBendStore().areHandlesSelected()) {
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.ALL_FAST);
            } else {
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
            }
        }

        private void mouseDraggedHandleNodesAndEdges(Collection<View<CyNode>> selectedNodes, MouseEvent e) {
            if (this.moveNodesEdit == null) {
                this.moveNodesEdit = new ViewChangeEdit(InputHandlerGlassPane.this.re, ViewChangeEdit.SavedObjs.SELECTED, "Move", InputHandlerGlassPane.this.registrar);
            }
            double[] ptBuff = new double[]{this.mousePressedPoint.getX(), this.mousePressedPoint.getY()};
            InputHandlerGlassPane.this.re.getTransform().xformImageToNodeCoords(ptBuff);
            double oldX = ptBuff[0];
            double oldY = ptBuff[1];
            this.mousePressedPoint = e.getPoint();
            ptBuff[0] = this.mousePressedPoint.getX();
            ptBuff[1] = this.mousePressedPoint.getY();
            InputHandlerGlassPane.this.re.getTransform().xformImageToNodeCoords(ptBuff);
            double newX = ptBuff[0];
            double newY = ptBuff[1];
            double deltaX = newX - oldX;
            double deltaY = newY - oldY;
            if (e.isShiftDown()) {
                double slope = deltaY / deltaX;
                if (slope > 2.41 || slope < -2.41) {
                    deltaX = 0.0;
                } else if (slope < 0.41 && slope > -0.41) {
                    deltaY = 0.0;
                } else {
                    double avg = (Math.abs(deltaX) + Math.abs(deltaY)) / 2.0;
                    deltaX = deltaX < 0.0 ? -avg : avg;
                    deltaY = deltaY < 0.0 ? -avg : avg;
                }
            }
            CyNetworkViewSnapshot snapshot = InputHandlerGlassPane.this.re.getViewModelSnapshot();
            if (InputHandlerGlassPane.this.re.getBendStore().areHandlesSelected()) {
                InputHandlerGlassPane.this.re.getBendStore().moveSelectedHandles((float)deltaX, (float)deltaY);
            } else {
                for (View<CyNode> node : selectedNodes) {
                    View mutableNode = snapshot.getMutableNodeView(node.getSUID().longValue());
                    if (mutableNode == null) continue;
                    NodeDetails nodeDetails = InputHandlerGlassPane.this.re.getNodeDetails();
                    double oldXPos = nodeDetails.getXPosition((View<CyNode>)mutableNode);
                    double oldYPos = nodeDetails.getYPosition((View<CyNode>)mutableNode);
                    mutableNode.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)(oldXPos + deltaX));
                    mutableNode.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)(oldYPos + deltaY));
                }
            }
            if (!selectedNodes.isEmpty() || InputHandlerGlassPane.this.re.getBendStore().areHandlesSelected()) {
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL);
            }
        }
    }

    private class TooltipListener
    extends MouseAdapter {
        private DebounceTimer delayTimer = new DebounceTimer(60);

        private TooltipListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.delayTimer.debounce(() -> this.showTooltip(e));
        }

        private void showTooltip(MouseEvent e) {
            View<CyEdge> edge;
            String text = null;
            View<CyNode> node = InputHandlerGlassPane.this.re.getPicker().getNodeAt(e.getPoint());
            if (node != null) {
                text = InputHandlerGlassPane.this.re.getNodeDetails().getTooltipText(node);
            } else if (InputHandlerGlassPane.this.edgeCountIsLowEnoughToEnablePicking() && (edge = InputHandlerGlassPane.this.re.getPicker().getEdgeAt(e.getPoint())) != null) {
                text = InputHandlerGlassPane.this.re.getEdgeDetails().getTooltipText(edge);
            }
            if (text == null || text.isBlank()) {
                return;
            }
            String tooltip = text.trim();
            ViewUtil.invokeOnEDT(() -> {
                InputHandlerGlassPane.this.setToolTipText(tooltip);
                ToolTipManager.sharedInstance().mouseMoved(e);
            });
        }
    }

    private class AddEdgeListener
    extends MouseAdapter {
        private final double[] coords = new double[2];
        private View<CyNode> sourceNode;
        private Point2D startPoint;
        private Point2D endPoint;

        private AddEdgeListener() {
        }

        public void beginAddingEdge(View<CyNode> nodeView) {
            this.sourceNode = nodeView;
            double x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            this.startPoint = new Point2D.Double(x, y);
            this.endPoint = new Point2D.Double(x, y);
        }

        public void reset() {
            this.sourceNode = null;
            this.startPoint = null;
            this.endPoint = null;
        }

        public boolean addingEdge() {
            return this.startPoint != null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.endPoint != null) {
                Point mousePoint = e.getPoint();
                this.coords[0] = ((Point2D)mousePoint).getX();
                this.coords[1] = ((Point2D)mousePoint).getY();
                InputHandlerGlassPane.this.re.getTransform().xformImageToNodeCoords(this.coords);
                this.endPoint.setLocation(this.coords[0], this.coords[1]);
                InputHandlerGlassPane.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.startPoint == null || this.endPoint == null) {
                return;
            }
            this.coords[0] = this.endPoint.getX();
            this.coords[1] = this.endPoint.getY();
            InputHandlerGlassPane.this.re.getTransform().xformNodeToImageCoords(this.coords);
            Point2D.Double ep = new Point2D.Double(this.coords[0], this.coords[1]);
            View<CyNode> targetNode = InputHandlerGlassPane.this.re.getPicker().getNodeAt(ep);
            if (targetNode != null) {
                this.createEdge(this.sourceNode, targetNode);
                this.reset();
                e.consume();
            }
        }

        public void drawAddingEdge(Graphics graphics) {
            if (this.startPoint == null || this.endPoint == null) {
                return;
            }
            this.coords[0] = this.startPoint.getX();
            this.coords[1] = this.startPoint.getY();
            InputHandlerGlassPane.this.re.getTransform().xformNodeToImageCoords(this.coords);
            double x1 = this.coords[0];
            double y1 = this.coords[1];
            this.coords[0] = this.endPoint.getX();
            this.coords[1] = this.endPoint.getY();
            InputHandlerGlassPane.this.re.getTransform().xformNodeToImageCoords(this.coords);
            double x2 = this.coords[0];
            double y2 = this.coords[1];
            double offset = 5.0;
            double lineLen = Math.sqrt((x2 - x1) * (x2 - x1)) + (y2 - y1) * (y2 - y1);
            if (lineLen == 0.0) {
                lineLen = 1.0;
            }
            y2 += (y1 - y2) / lineLen * offset;
            x2 += (x1 - x2) / lineLen * offset;
            Graphics2D g = (Graphics2D)graphics.create();
            g.setColor(Color.BLACK);
            g.drawLine((int)x1 - 1, (int)y1 - 1, (int)x2 + 1, (int)y2 + 1);
        }

        private void createEdge(View<CyNode> sourceNodeView, View<CyNode> targetNodeView) {
            CyNetworkViewSnapshot netView = InputHandlerGlassPane.this.re.getViewModelSnapshot();
            AddEdgeTask addEdgeTask = new AddEdgeTask(InputHandlerGlassPane.this.registrar, netView, sourceNodeView, targetNodeView);
            DialogTaskManager taskManager = (DialogTaskManager)InputHandlerGlassPane.this.registrar.getService(DialogTaskManager.class);
            taskManager.execute(new TaskIterator(new Task[]{addEdgeTask}));
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private boolean doublePressed = false;

        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (ViewUtil.isDoubleLeftClick(e)) {
                DingAnnotation annotation;
                NetworkPicker picker = InputHandlerGlassPane.this.re.getPicker();
                if (InputHandlerGlassPane.this.annotationSelectionEnabled() && (annotation = picker.getAnnotationAt(e.getPoint())) != null) {
                    this.editAnnotation(annotation, e.getPoint());
                    e.consume();
                    return;
                }
                this.showContextMenu(e.getPoint());
                e.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ViewUtil.isDoubleLeftClick(e)) {
                e.consume();
                this.doublePressed = true;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.doublePressed) {
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.doublePressed) {
                e.consume();
            }
            this.doublePressed = false;
        }

        private void showContextMenu(Point p) {
            NetworkPicker picker = InputHandlerGlassPane.this.re.getPicker();
            View<CyNode> node = picker.getNodeAt(p);
            if (node != null) {
                InputHandlerGlassPane.this.popupMenuHelper.createNodeViewMenu(node, p.x, p.y, "OPEN");
                return;
            }
            View<CyEdge> edge = picker.getEdgeAt(p);
            if (edge != null) {
                InputHandlerGlassPane.this.popupMenuHelper.createEdgeViewMenu(edge, p.x, p.y, "OPEN");
                return;
            }
            Point2D nodePt = InputHandlerGlassPane.this.re.getTransform().getNodeCoordinates(p);
            Point xformPt = new Point();
            xformPt.setLocation(nodePt.getX(), nodePt.getY());
            InputHandlerGlassPane.this.popupMenuHelper.createNetworkViewMenu(p, xformPt, "OPEN");
        }

        private void editAnnotation(DingAnnotation annotation, Point p) {
            ViewUtil.invokeOnEDT(() -> {
                DialogTaskManager tm = (DialogTaskManager)InputHandlerGlassPane.this.registrar.getService(DialogTaskManager.class);
                NetworkViewLocationTaskFactory f = (NetworkViewLocationTaskFactory)InputHandlerGlassPane.this.registrar.getService(NetworkViewLocationTaskFactory.class, "(id=editAnnotationTaskFactory)");
                if (f instanceof EditAnnotationTaskFactory) {
                    tm.execute(((EditAnnotationTaskFactory)f).createTaskIterator(annotation, InputHandlerGlassPane.this.re.getViewModel(), (Point2D)p));
                }
            });
        }
    }

    private class ContextMenuListener
    extends MouseAdapter {
        private ContextMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ViewUtil.isSingleRightClick(e)) {
                this.showContextMenu(e.getPoint());
                e.consume();
                InputHandlerGlassPane.this.get(AddAnnotationListener.class).cancel();
            }
        }

        private void showContextMenu(Point p) {
            View<CyNode> nodeView = InputHandlerGlassPane.this.re.getPicker().getNodeAt(p);
            if (nodeView != null) {
                InputHandlerGlassPane.this.popupMenuHelper.createNodeViewMenu(nodeView, p.x, p.y, "NEW");
                return;
            }
            View<CyEdge> edgeView = InputHandlerGlassPane.this.re.getPicker().getEdgeAt(p);
            if (edgeView != null) {
                InputHandlerGlassPane.this.popupMenuHelper.createEdgeViewMenu(edgeView, p.x, p.y, "NEW");
                return;
            }
            double[] loc = new double[]{p.getX(), p.getY()};
            InputHandlerGlassPane.this.re.getTransform().xformImageToNodeCoords(loc);
            Point xformP = new Point();
            xformP.setLocation(loc[0], loc[1]);
            InputHandlerGlassPane.this.popupMenuHelper.createNetworkViewMenu(p, xformP, "NEW");
        }
    }

    private class FocusRequestListener
    extends MouseAdapter {
        private FocusRequestListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            InputHandlerGlassPane.this.requestFocusInWindow();
        }
    }

    private class CanvasMouseWheelListener
    implements MouseWheelListener {
        private CanvasMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            InputHandlerGlassPane.this.re.zoom(e.getWheelRotation());
            InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL);
        }
    }

    private class CanvasKeyListener
    extends MouseAdapter
    implements KeyListener {
        private final int KEYPRESS_TIMER_DELAY = 600;
        private AnnotationEdit moveAnnotationsEdit;
        private ViewChangeEdit moveNodesEdit;
        private ViewChangeEdit panEdit;
        private CompositeCyEdit<LabelEdit> labelEdit;
        private DRenderingEngine.Panner panner = null;
        private Timer swingTimer;

        private CanvasKeyListener() {
        }

        private void endEdit() {
            if (this.swingTimer != null) {
                this.swingTimer.stop();
                this.swingTimer = null;
            }
            if (this.labelEdit != null) {
                this.labelEdit.getChildren().forEach(LabelEdit::savePositionAndAngle);
                this.labelEdit.post();
            } else if (this.moveAnnotationsEdit != null || this.moveNodesEdit != null || this.panEdit != null) {
                if (this.moveAnnotationsEdit != null) {
                    this.moveAnnotationsEdit.saveNewAnnotations();
                }
                if (this.moveNodesEdit != null) {
                    this.moveNodesEdit.saveNewPositions();
                }
                if (this.panEdit != null) {
                    this.panEdit.saveNewPositions();
                }
                CompositeCyEdit<AnnotationEdit> composite = new CompositeCyEdit<AnnotationEdit>("Move", InputHandlerGlassPane.this.registrar, 3);
                composite.add(this.moveAnnotationsEdit).add((AnnotationEdit)((Object)this.moveNodesEdit)).add((AnnotationEdit)((Object)this.panEdit));
                composite.post();
                if (this.panner != null) {
                    this.panner.endPan();
                }
            }
            this.moveAnnotationsEdit = null;
            this.moveNodesEdit = null;
            this.panEdit = null;
            this.labelEdit = null;
            this.panner = null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.endEdit();
        }

        private void resetMoveTimer() {
            if (this.swingTimer == null) {
                this.swingTimer = new Timer(600, ev -> this.endEdit());
                this.swingTimer.start();
            } else {
                this.swingTimer.restart();
            }
        }

        private int getMoveAmountImageUnit(KeyEvent e) {
            return e.isShiftDown() ? 15 : 2;
        }

        private float getMoveAmountNodeUnit(KeyEvent e) {
            int imageUnit = this.getMoveAmountImageUnit(e);
            float nodeUnit = InputHandlerGlassPane.this.re.getTransform().getNodeDistance(imageUnit);
            return nodeUnit;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            boolean allChanged = false;
            boolean annotationsChanged = false;
            boolean moved = false;
            if (code == 38 || code == 40 || code == 37 || code == 39) {
                if (ViewUtil.isControlOrMetaDown(e)) {
                    this.panCanvas(e);
                    allChanged = true;
                    moved = true;
                } else if (InputHandlerGlassPane.this.labelSelectionEnabled() && !InputHandlerGlassPane.this.re.getLabelSelectionManager().isEmpty()) {
                    allChanged = this.moveNodeLabels(e);
                    moved |= allChanged;
                } else {
                    if (InputHandlerGlassPane.this.nodeSelectionEnabled()) {
                        allChanged = this.moveNodesAndHandles(e);
                        moved |= allChanged;
                    }
                    if (InputHandlerGlassPane.this.annotationSelectionEnabled()) {
                        annotationsChanged = this.moveAnnotations(e);
                        moved |= annotationsChanged;
                    }
                }
            } else if (code == 27) {
                allChanged = this.cancelAddingEdge();
                if (InputHandlerGlassPane.this.annotationSelectionEnabled()) {
                    allChanged |= this.cancelAnnotations();
                }
            } else if (code == 8 || code == 127) {
                this.deleteSelected();
            }
            if (allChanged) {
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL);
            } else if (annotationsChanged) {
                InputHandlerGlassPane.this.re.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
            }
            if (moved) {
                this.resetMoveTimer();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            AnnotationSelection annotationSelection = InputHandlerGlassPane.this.cyAnnotator.getAnnotationSelection();
            if (InputHandlerGlassPane.this.annotationSelectionEnabled() && !annotationSelection.isEmpty() && code == 127) {
                for (DingAnnotation a : annotationSelection) {
                    a.removeAnnotation();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private boolean moveAnnotations(KeyEvent e) {
            AnnotationSelection selection = InputHandlerGlassPane.this.cyAnnotator.getAnnotationSelection();
            if (selection.isEmpty()) {
                return false;
            }
            Point start = InputHandlerGlassPane.this.re.getTransform().getImageCoordinates(selection.getLocation());
            int x = start.x;
            int y = start.y;
            if (this.moveAnnotationsEdit == null) {
                String message = selection.size() == 1 ? "Move Annotation" : "Move Annotations";
                this.moveAnnotationsEdit = new AnnotationEdit(message, InputHandlerGlassPane.this.re);
            }
            int move = this.getMoveAmountImageUnit(e);
            switch (e.getKeyCode()) {
                case 38: {
                    y -= move;
                    break;
                }
                case 40: {
                    y += move;
                    break;
                }
                case 37: {
                    x -= move;
                    break;
                }
                case 39: {
                    x += move;
                }
            }
            selection.setMovingStartOffset(start);
            selection.moveSelection(x, y);
            return true;
        }

        private boolean cancelAnnotations() {
            if (InputHandlerGlassPane.this.cyAnnotator.getResizeShape() != null) {
                InputHandlerGlassPane.this.cyAnnotator.getResizeShape().contentChanged();
                InputHandlerGlassPane.this.cyAnnotator.resizeShape(null);
                InputHandlerGlassPane.this.cyAnnotator.postUndoEdit();
                return true;
            }
            if (InputHandlerGlassPane.this.cyAnnotator.getRepositioningArrow() != null) {
                InputHandlerGlassPane.this.cyAnnotator.removeAnnotation(InputHandlerGlassPane.this.cyAnnotator.getRepositioningArrow());
                InputHandlerGlassPane.this.cyAnnotator.clearUndoEdit();
                return true;
            }
            return false;
        }

        private void panCanvas(KeyEvent k) {
            if (this.panEdit == null) {
                this.panEdit = new ViewChangeEdit(InputHandlerGlassPane.this.re, null, "Pan", InputHandlerGlassPane.this.registrar);
            }
            if (this.panner == null) {
                this.panner = InputHandlerGlassPane.this.re.startPan();
            }
            float move = this.getMoveAmountNodeUnit(k);
            switch (k.getKeyCode()) {
                case 38: {
                    this.panner.continuePan(0.0, move);
                    break;
                }
                case 40: {
                    this.panner.continuePan(0.0, -move);
                    break;
                }
                case 37: {
                    this.panner.continuePan(move, 0.0);
                    break;
                }
                case 39: {
                    this.panner.continuePan(-move, 0.0);
                }
            }
        }

        private boolean moveNodesAndHandles(KeyEvent k) {
            CyNetworkViewSnapshot snapshot = InputHandlerGlassPane.this.re.getViewModelSnapshot();
            Collection selectedNodes = snapshot.getTrackedNodes(DingNetworkViewFactory.SELECTED_NODES);
            if (!selectedNodes.isEmpty() && this.moveNodesEdit == null) {
                this.moveNodesEdit = new ViewChangeEdit(InputHandlerGlassPane.this.re, ViewChangeEdit.SavedObjs.SELECTED, "Move", InputHandlerGlassPane.this.registrar);
            }
            float move = this.getMoveAmountNodeUnit(k);
            for (View node : selectedNodes) {
                double xPos = InputHandlerGlassPane.this.re.getNodeDetails().getXPosition((View<CyNode>)node);
                double yPos = InputHandlerGlassPane.this.re.getNodeDetails().getYPosition((View<CyNode>)node);
                switch (k.getKeyCode()) {
                    case 38: {
                        yPos -= (double)move;
                        break;
                    }
                    case 40: {
                        yPos += (double)move;
                        break;
                    }
                    case 37: {
                        xPos -= (double)move;
                        break;
                    }
                    case 39: {
                        xPos += (double)move;
                    }
                }
                View mutableNodeView = snapshot.getMutableNodeView(node.getSUID().longValue());
                mutableNodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)xPos);
                mutableNodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)yPos);
            }
            if (InputHandlerGlassPane.this.re.getBendStore().areHandlesSelected()) {
                float dx = 0.0f;
                float dy = 0.0f;
                switch (k.getKeyCode()) {
                    case 38: {
                        dy = -move;
                        break;
                    }
                    case 40: {
                        dy = move;
                        break;
                    }
                    case 37: {
                        dx = -move;
                        break;
                    }
                    case 39: {
                        dx = move;
                    }
                }
                InputHandlerGlassPane.this.re.getBendStore().moveSelectedHandles(dx, dy);
            }
            return !selectedNodes.isEmpty() || InputHandlerGlassPane.this.re.getBendStore().areHandlesSelected();
        }

        private boolean moveNodeLabels(KeyEvent k) {
            LabelSelectionManager labelSelectionManager = InputHandlerGlassPane.this.re.getLabelSelectionManager();
            Collection<LabelSelection> selectedLabels = labelSelectionManager.getSelectedLabels();
            if (selectedLabels == null || selectedLabels.isEmpty()) {
                return false;
            }
            if (this.labelEdit == null) {
                this.labelEdit = new CompositeCyEdit("Move Labels", InputHandlerGlassPane.this.registrar, selectedLabels.size());
                for (LabelSelection selectedLabel : selectedLabels) {
                    View mutableNode = InputHandlerGlassPane.this.re.getViewModelSnapshot().getMutableNodeView(selectedLabel.getNode().getSUID().longValue());
                    Long suid = ((CyNode)mutableNode.getModel()).getSUID();
                    LabelEdit edit = new LabelEdit(InputHandlerGlassPane.this.registrar, InputHandlerGlassPane.this.re, InputHandlerGlassPane.this.re.getViewModel(), suid, selectedLabel);
                    this.labelEdit.add(edit);
                }
            }
            ObjectPosition pos = selectedLabels.iterator().next().getPosition();
            Point start = InputHandlerGlassPane.this.re.getTransform().getImageCoordinates(pos.getOffsetX(), pos.getOffsetY());
            int x = start.x;
            int y = start.y;
            int move = this.getMoveAmountImageUnit(k);
            switch (k.getKeyCode()) {
                case 38: {
                    y -= move;
                    break;
                }
                case 40: {
                    y += move;
                    break;
                }
                case 37: {
                    x -= move;
                    break;
                }
                case 39: {
                    x += move;
                }
            }
            labelSelectionManager.setCurrentDragPoint(start);
            labelSelectionManager.move(new Point(x, y));
            for (LabelSelection selectedLabel : InputHandlerGlassPane.this.re.getLabelSelectionManager().getSelectedLabels()) {
                View mutableNode = InputHandlerGlassPane.this.re.getViewModelSnapshot().getMutableNodeView(selectedLabel.getNode().getSUID().longValue());
                ObjectPosition newPosition = selectedLabel.getPosition();
                double newAngle = selectedLabel.getAngleDegrees();
                mutableNode.setLockedValue(DVisualLexicon.NODE_LABEL_POSITION, (Object)newPosition);
                mutableNode.setLockedValue(DVisualLexicon.NODE_LABEL_ROTATION, (Object)newAngle);
            }
            return true;
        }

        private boolean cancelAddingEdge() {
            AddEdgeListener addEdgeListener = InputHandlerGlassPane.this.get(AddEdgeListener.class);
            if (addEdgeListener.addingEdge()) {
                addEdgeListener.reset();
                return true;
            }
            return false;
        }

        private void deleteSelected() {
            TaskIterator tasks = new TaskIterator(new Task[0]);
            NetworkViewTaskFactory f = (NetworkViewTaskFactory)InputHandlerGlassPane.this.registrar.getService(NetworkViewTaskFactory.class, "(id=removeSelectedAnnotationsTaskFactory)");
            if (f.isReady(InputHandlerGlassPane.this.re.getViewModel())) {
                tasks.append(f.createTaskIterator(InputHandlerGlassPane.this.re.getViewModel()));
            }
            if ((f = (DeleteSelectedNodesAndEdgesTaskFactory)InputHandlerGlassPane.this.registrar.getService(DeleteSelectedNodesAndEdgesTaskFactory.class)).isReady((CyNetwork)InputHandlerGlassPane.this.re.getViewModel().getModel())) {
                tasks.append(f.createTaskIterator((CyNetwork)InputHandlerGlassPane.this.re.getViewModel().getModel()));
            }
            TaskManager taskManager = (TaskManager)InputHandlerGlassPane.this.registrar.getService(TaskManager.class);
            taskManager.execute(tasks);
        }
    }
}

