/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.util.Objects;
import org.cytoscape.model.CyEdge;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.Handle;

public class HandleInfo {
    private final long edgeSuid;
    private final Bend bend;
    private final Handle handle;

    public HandleInfo(View<CyEdge> edge, Bend bend, Handle handle) {
        this(edge.getSUID(), bend, handle);
    }

    public HandleInfo(long suid, Bend bend, Handle handle) {
        this.edgeSuid = suid;
        this.bend = bend;
        this.handle = handle;
    }

    public HandleInfo forNewBend(Bend newBend) {
        if (newBend == this.bend) {
            return this;
        }
        Handle handle = (Handle)newBend.getAllHandles().get(this.getHandleIndex());
        return new HandleInfo(this.edgeSuid, newBend, handle);
    }

    public long getSUID() {
        return this.edgeSuid;
    }

    public Bend getBend() {
        return this.bend;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public int getHandleIndex() {
        return this.bend.getIndex(this.handle);
    }

    public int hashCode() {
        return Objects.hash(this.handle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HandleInfo)) {
            return false;
        }
        HandleInfo other = (HandleInfo)obj;
        return Objects.equals(this.handle, other.handle);
    }
}

