/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.geom.Point2D;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.values.Handle;

public class HandleImpl
implements Handle {
    private static final String DELIMITER = ",";
    private double cosTheta = Double.NaN;
    private double sinTheta = Double.NaN;
    private double ratio = Double.NaN;
    private double x = 0.0;
    private double y = 0.0;

    public HandleImpl(CyNetworkView graphView, View<CyEdge> view, double x, double y) {
        this.defineHandle(graphView, view, x, y);
    }

    public HandleImpl(HandleImpl h) {
        this.x = h.x;
        this.y = h.y;
        this.cosTheta = h.cosTheta;
        this.sinTheta = h.sinTheta;
        this.ratio = h.ratio;
    }

    private static View<CyNode> getSourceNodeView(CyNetworkView graphView, View<CyEdge> edge) {
        if (graphView instanceof CyNetworkViewSnapshot) {
            return ((CyNetworkViewSnapshot)graphView).getEdgeInfo(edge).getSourceNodeView();
        }
        return graphView.getNodeView(((CyEdge)edge.getModel()).getSource());
    }

    private static View<CyNode> getTargetNodeView(CyNetworkView graphView, View<CyEdge> edge) {
        if (graphView instanceof CyNetworkViewSnapshot) {
            return ((CyNetworkViewSnapshot)graphView).getEdgeInfo(edge).getTargetNodeView();
        }
        return graphView.getNodeView(((CyEdge)edge.getModel()).getTarget());
    }

    public Point2D calculateHandleLocation(CyNetworkView graphView, View<CyEdge> view) {
        if (Double.isNaN(this.sinTheta) || Double.isNaN(this.cosTheta)) {
            this.defineHandle(graphView, view, this.x, this.y);
        }
        View<CyNode> sourceView = HandleImpl.getSourceNodeView(graphView, view);
        View<CyNode> targetView = HandleImpl.getTargetNodeView(graphView, view);
        double sX = (Double)sourceView.getVisualProperty(DVisualLexicon.NODE_X_LOCATION);
        double sY = (Double)sourceView.getVisualProperty(DVisualLexicon.NODE_Y_LOCATION);
        double tX = (Double)targetView.getVisualProperty(DVisualLexicon.NODE_X_LOCATION);
        double tY = (Double)targetView.getVisualProperty(DVisualLexicon.NODE_Y_LOCATION);
        Point2D newPoint = this.convert(sX, sY, tX, tY);
        return newPoint;
    }

    public void defineHandle(CyNetworkView graphView, View<CyEdge> view, double x, double y) {
        if (!Double.isNaN(x)) {
            this.x = x;
        }
        if (!Double.isNaN(y)) {
            this.y = y;
        }
        if (graphView != null && view != null) {
            this.convertToRatio(graphView, view, new Point2D.Double(this.x, this.y));
        }
    }

    private void convertToRatio(CyNetworkView graphView, View<CyEdge> view, Point2D absolutePoint) {
        View<CyNode> sourceView = HandleImpl.getSourceNodeView(graphView, view);
        View<CyNode> targetView = HandleImpl.getTargetNodeView(graphView, view);
        double sX = (Double)sourceView.getVisualProperty(DVisualLexicon.NODE_X_LOCATION);
        double sY = (Double)sourceView.getVisualProperty(DVisualLexicon.NODE_Y_LOCATION);
        double tX = (Double)targetView.getVisualProperty(DVisualLexicon.NODE_X_LOCATION);
        double tY = (Double)targetView.getVisualProperty(DVisualLexicon.NODE_Y_LOCATION);
        double hX = absolutePoint.getX();
        double hY = absolutePoint.getY();
        double v1x = tX - sX;
        double v1y = tY - sY;
        double dist1 = Point2D.Double.distance(sX, sY, tX, tY);
        if (dist1 == 0.0) {
            this.ratio = 0.0;
            this.cosTheta = 0.0;
            this.sinTheta = 0.0;
        } else {
            double v2x = hX - sX;
            double v2y = hY - sY;
            double dist2 = Point2D.Double.distance(sX, sY, hX, hY);
            this.ratio = dist2 / dist1;
            double dotProduct = v1x * v2x + v1y * v2y;
            this.cosTheta = dotProduct / (dist1 * dist2);
            if (this.cosTheta > 1.0) {
                this.cosTheta = 1.0;
            }
            double theta = Math.acos(this.cosTheta);
            this.sinTheta = Math.sin(theta);
            Point2D validate = this.convert(sX, sY, tX, tY);
            if (Math.abs(validate.getX() - hX) > 2.0 || Math.abs(validate.getY() - hY) > 2.0) {
                this.sinTheta = -this.sinTheta;
            }
            if (Double.isNaN(theta) || Double.isNaN(this.sinTheta)) {
                throw new IllegalStateException("Invalid angle: " + theta + ". Cuased by cos(theta) = " + this.cosTheta);
            }
        }
    }

    private Point2D convert(double sX, double sY, double tX, double tY) {
        Point2D.Double newPoint = new Point2D.Double();
        double vx = tX - sX;
        double vy = tY - sY;
        double newX = vx * this.cosTheta - vy * this.sinTheta;
        double newY = vx * this.sinTheta + vy * this.cosTheta;
        double handleX = (newX *= this.ratio) + sX;
        double handleY = (newY *= this.ratio) + sY;
        ((Point2D)newPoint).setLocation(handleX, handleY);
        return newPoint;
    }

    public String getSerializableString() {
        return this.cosTheta + DELIMITER + this.sinTheta + DELIMITER + this.ratio;
    }

    private void setCos(double cos) {
        this.cosTheta = cos;
    }

    private void setSin(double sin) {
        this.sinTheta = sin;
    }

    private void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public static Handle parseSerializableString(String strRepresentation) {
        if (strRepresentation == null) {
            return null;
        }
        String[] parts = strRepresentation.split(DELIMITER);
        if (parts.length == 2) {
            return HandleImpl.process2xHandles(parts);
        }
        if (parts.length != 3) {
            return null;
        }
        try {
            double cos = Double.valueOf(parts[0]);
            double sin = Double.valueOf(parts[1]);
            double ratio = Double.valueOf(parts[2]);
            HandleImpl handle = new HandleImpl(null, null, 0.0, 0.0);
            handle.setSin(sin);
            handle.setCos(cos);
            handle.setRatio(ratio);
            return handle;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static final Handle process2xHandles(String[] parts) {
        try {
            double x = Double.valueOf(parts[0]);
            double y = Double.valueOf(parts[1]);
            return new HandleImpl(null, null, x, y);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String toString() {
        return "handle x:" + this.x + " y:" + this.y + " cosTheta: " + this.cosTheta + " sinTheta: " + this.sinTheta + " ratio: " + this.ratio;
    }
}

