/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.ding.impl.ThumbnailView;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;

public class DingThumbnailRenderingEngineFactory
implements RenderingEngineFactory<CyNetwork> {
    private final DingNetworkViewFactory viewFactoryMediator;
    private final VisualLexicon dingLexicon;
    private final CyServiceRegistrar registrar;

    public DingThumbnailRenderingEngineFactory(DingNetworkViewFactory viewFactoryMediator, VisualLexicon dingLexicon, CyServiceRegistrar registrar) {
        this.viewFactoryMediator = viewFactoryMediator;
        this.dingLexicon = dingLexicon;
        this.registrar = registrar;
    }

    public RenderingEngine<CyNetwork> createRenderingEngine(Object visualizationContainer, View<CyNetwork> view) {
        if (visualizationContainer == null) {
            throw new IllegalArgumentException("Visualization container is null.  This should be an JComponent for this rendering engine.");
        }
        if (view == null) {
            throw new IllegalArgumentException("View Model is null.");
        }
        if (!(visualizationContainer instanceof JComponent) || !(view instanceof CyNetworkView)) {
            throw new IllegalArgumentException("Visualization Container object is not of type Component, which is invalid for this implementation of PresentationFactory");
        }
        DRenderingEngine re = this.viewFactoryMediator.getRenderingEngine((CyNetworkView)view);
        JComponent container = (JComponent)visualizationContainer;
        ThumbnailView tv = new ThumbnailView(re);
        container.setLayout(new BorderLayout());
        container.add((Component)tv, "Center");
        return tv;
    }

    public VisualLexicon getVisualLexicon() {
        return this.dingLexicon;
    }
}

