/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.DingNetworkViewFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;

public class DingRenderingEngineFactory
implements RenderingEngineFactory<CyNetwork> {
    private final DingNetworkViewFactory viewFactory;
    private final VisualLexicon dingLexicon;

    public DingRenderingEngineFactory(DingNetworkViewFactory viewFactory, VisualLexicon dingLexicon) {
        this.viewFactory = viewFactory;
        this.dingLexicon = dingLexicon;
    }

    public RenderingEngine<CyNetwork> createRenderingEngine(Object container, View<CyNetwork> view) {
        if (container == null) {
            throw new IllegalArgumentException("Container is null.");
        }
        if (view == null) {
            throw new IllegalArgumentException("Cannot create presentation for null view model.");
        }
        if (!(view instanceof CyNetworkView)) {
            throw new IllegalArgumentException("Ding accepts CyNetworkView only.");
        }
        DRenderingEngine re = this.viewFactory.getRenderingEngine((CyNetworkView)view);
        if (container instanceof RootPaneContainer) {
            RootPaneContainer rootPane = (RootPaneContainer)container;
            re.install(rootPane);
        } else if (container instanceof JComponent) {
            JComponent component = (JComponent)container;
            re.install(component);
        } else {
            throw new IllegalArgumentException("container object must be of type JComponent or RootPaneContainer");
        }
        return re;
    }

    public VisualLexicon getVisualLexicon() {
        return this.dingLexicon;
    }
}

