/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.util.Properties;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.graph.render.stateful.GraphLOD;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.property.PropertyUpdatedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;

public class DingGraphLOD
implements GraphLOD,
PropertyUpdatedListener {
    protected int coarseDetailThreshold;
    protected int nodeBorderThreshold;
    protected int nodeLabelThreshold;
    protected int edgeArrowThreshold;
    protected int edgeLabelThreshold;
    protected boolean edgeBufferPan;
    protected boolean labelCache;
    protected boolean hidpi;
    private final Properties props;
    private final CyProperty<Properties> cyProp;
    private final CyServiceRegistrar serviceRegistrar;

    public DingGraphLOD(CyServiceRegistrar serviceRegistrar) {
        this.cyProp = (CyProperty)serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.props = (Properties)this.cyProp.getProperties();
        this.serviceRegistrar = serviceRegistrar;
        this.updateProps();
    }

    private void updateProps() {
        this.coarseDetailThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.coarseDetailThreshold"), 4000);
        this.nodeBorderThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.nodeBorderThreshold"), 400);
        this.nodeLabelThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.nodeLabelThreshold"), 200);
        this.edgeArrowThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.edgeArrowThreshold"), 600);
        this.edgeLabelThreshold = DingGraphLOD.parseInt(this.props.getProperty("render.edgeLabelThreshold"), 200);
        this.edgeBufferPan = Boolean.valueOf(this.props.getProperty("render.edgeBufferPan"));
        this.labelCache = Boolean.valueOf(this.props.getProperty("render.labelCache"));
        this.hidpi = Boolean.valueOf(this.props.getProperty("render.hidpi"));
    }

    private static int parseInt(String intString, int defaultValue) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public GraphLOD faster() {
        return new GraphLOD(){

            @Override
            public GraphLOD.RenderEdges renderEdges(int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
                return DingGraphLOD.this.renderEdges(false, visibleNodeCount, totalNodeCount, totalEdgeCount);
            }

            @Override
            public boolean detail(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.detail(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean nodeBorders(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.nodeBorders(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean nodeLabels(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.nodeLabels(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean customGraphics(int renderNodeCount, int renderEdgeCount) {
                return renderNodeCount < DingGraphLOD.this.nodeLabelThreshold;
            }

            @Override
            public boolean edgeArrows(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.edgeArrows(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean dashedEdges(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.dashedEdges(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean edgeAnchors(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.edgeAnchors(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean edgeLabels(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.edgeLabels(renderNodeCount, renderEdgeCount);
            }

            @Override
            public boolean textAsShape(int renderNodeCount, int renderEdgeCount) {
                return DingGraphLOD.this.textAsShape(renderNodeCount, renderEdgeCount);
            }

            @Override
            public double getNestedNetworkImageScaleFactor() {
                return DingGraphLOD.this.getNestedNetworkImageScaleFactor();
            }

            @Override
            public boolean isEdgeBufferPanEnabled() {
                return DingGraphLOD.this.isEdgeBufferPanEnabled();
            }

            @Override
            public boolean isLabelCacheEnabled() {
                return DingGraphLOD.this.isLabelCacheEnabled();
            }

            @Override
            public boolean isHidpiEnabled() {
                return DingGraphLOD.this.isHidpiEnabled();
            }
        };
    }

    public void handleEvent(PropertyUpdatedEvent e) {
        if (!((CyProperty)e.getSource()).equals(this.cyProp)) {
            return;
        }
        this.updateProps();
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        if (view != null) {
            view.updateView();
        }
    }

    @Override
    public GraphLOD.RenderEdges renderEdges(int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
        return this.renderEdges(true, visibleNodeCount, totalNodeCount, totalEdgeCount);
    }

    private GraphLOD.RenderEdges renderEdges(boolean drawEdges, int visibleNodeCount, int totalNodeCount, int totalEdgeCount) {
        if (totalEdgeCount >= Math.min(this.edgeArrowThreshold, this.edgeLabelThreshold)) {
            if (drawEdges || visibleNodeCount <= Math.max(this.edgeArrowThreshold, this.edgeLabelThreshold) / 2) {
                return GraphLOD.RenderEdges.TOUCHING_VISIBLE_NODES;
            }
            return GraphLOD.RenderEdges.NONE;
        }
        return GraphLOD.RenderEdges.ALL;
    }

    @Override
    public boolean detail(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount + renderEdgeCount < this.coarseDetailThreshold;
    }

    @Override
    public boolean nodeBorders(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    @Override
    public boolean nodeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeLabelThreshold;
    }

    @Override
    public boolean customGraphics(int renderNodeCount, int renderEdgeCount) {
        return renderNodeCount < this.nodeBorderThreshold;
    }

    @Override
    public boolean edgeArrows(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeArrowThreshold;
    }

    @Override
    public boolean dashedEdges(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    @Override
    public boolean edgeAnchors(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeArrowThreshold;
    }

    @Override
    public boolean edgeLabels(int renderNodeCount, int renderEdgeCount) {
        return renderEdgeCount < this.edgeLabelThreshold;
    }

    @Override
    public boolean textAsShape(int renderNodeCount, int renderEdgeCount) {
        return true;
    }

    @Override
    public boolean isEdgeBufferPanEnabled() {
        return this.edgeBufferPan;
    }

    @Override
    public boolean isLabelCacheEnabled() {
        return this.labelCache;
    }

    @Override
    public boolean isHidpiEnabled() {
        return this.hidpi;
    }

    @Override
    public double getNestedNetworkImageScaleFactor() {
        String scaleFactor = this.props.getProperty("nestedNetwork.imageScaleFactor", "1.0");
        try {
            double d = Double.valueOf(scaleFactor);
            return d <= 0.0 ? 1.0 : d;
        }
        catch (Exception e) {
            return 1.0;
        }
    }
}

