/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.impl;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.print.Printable;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.cytoscape.ding.impl.BirdsEyeViewLOD;
import org.cytoscape.ding.impl.ContentChangeListener;
import org.cytoscape.ding.impl.DRenderingEngine;
import org.cytoscape.ding.impl.canvas.BirdsEyeViewRenderComponent;
import org.cytoscape.ding.impl.canvas.NetworkTransform;
import org.cytoscape.ding.impl.canvas.RenderComponent;
import org.cytoscape.ding.internal.util.ViewUtil;
import org.cytoscape.event.DebounceTimer;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewSnapshot;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;

public final class BirdsEyeView
implements RenderingEngine<CyNetwork>,
ContentChangeListener {
    private static final double SCALE_FACTOR = 0.97;
    private final double[] extents = new double[4];
    private DRenderingEngine re;
    private final CyServiceRegistrar registrar;
    private final RenderComponent renderComponent;
    private final DebounceTimer contentChangedTimer;

    public BirdsEyeView(DRenderingEngine re, CyServiceRegistrar registrar) {
        this.re = re;
        this.registrar = registrar;
        BirdsEyeViewLOD lod = new BirdsEyeViewLOD(re.getGraphLOD());
        this.renderComponent = new BirdsEyeViewRenderComponent(re, lod);
        this.renderComponent.setBackgroundPaint(re.getBackgroundColor());
        this.renderComponent.showAnnotationSelection(false);
        InnerMouseListener mouseListener = new InnerMouseListener();
        this.renderComponent.addMouseListener(mouseListener);
        this.renderComponent.addMouseMotionListener(mouseListener);
        this.renderComponent.addMouseWheelListener(mouseListener);
        re.addTransformChangeListener(this.renderComponent::repaint);
        re.addContentChangeListener(this);
        this.contentChangedTimer = new DebounceTimer(200);
        this.renderComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BirdsEyeView.this.contentChanged(DRenderingEngine.UpdateType.ALL_FAST);
                e.getComponent().removeComponentListener(this);
            }
        });
    }

    @Override
    public void contentChanged(DRenderingEngine.UpdateType updateType) {
        if (updateType == DRenderingEngine.UpdateType.JUST_ANNOTATIONS) {
            this.renderComponent.updateView(DRenderingEngine.UpdateType.JUST_ANNOTATIONS);
        } else {
            this.renderComponent.updateView(DRenderingEngine.UpdateType.ALL_FAST);
        }
        if (!this.contentChangedTimer.isShutdown()) {
            this.contentChangedTimer.debounce(() -> {
                boolean changed = this.fitCanvasToNetwork();
                if (changed |= !this.renderComponent.getBackgroundPaint().equals(this.re.getBackgroundColor())) {
                    this.renderComponent.setBackgroundPaint(this.re.getBackgroundColor());
                    this.renderComponent.updateView(DRenderingEngine.UpdateType.ALL_FULL);
                }
            });
        }
    }

    public JComponent getComponent() {
        return this.renderComponent;
    }

    public Image createImage(int width, int height) {
        return null;
    }

    private boolean getNetworkExtents(double[] extents) {
        CyNetworkViewSnapshot netViewSnapshot = this.re.getViewModelSnapshot();
        if (netViewSnapshot.getNodeCount() == 0) {
            Arrays.fill(extents, 0.0);
            return false;
        }
        netViewSnapshot.getSpacialIndex2D().getMBR(extents);
        return true;
    }

    private boolean fitCanvasToNetwork() {
        double myScaleFactor;
        double myYCenter;
        double myXCenter;
        boolean hasComponents = this.getNetworkExtents(this.extents);
        if (hasComponents |= this.re.getCyAnnotator().adjustBoundsToIncludeAnnotations(this.extents)) {
            myXCenter = (this.extents[0] + this.extents[2]) / 2.0;
            myYCenter = (this.extents[1] + this.extents[3]) / 2.0;
            myScaleFactor = 0.97 * Math.min((double)this.renderComponent.getWidth() / (this.extents[2] - this.extents[0]), (double)this.renderComponent.getHeight() / (this.extents[3] - this.extents[1]));
        } else {
            myXCenter = 0.0;
            myYCenter = 0.0;
            myScaleFactor = 1.0;
        }
        NetworkTransform t = this.renderComponent.getTransform();
        if (t.getCenterX() == myXCenter && t.getCenterY() == myYCenter && t.getScaleFactor() == myScaleFactor) {
            return false;
        }
        this.renderComponent.setCenter(myXCenter, myYCenter);
        this.renderComponent.setScaleFactor(myScaleFactor);
        return true;
    }

    public View<CyNetwork> getViewModel() {
        return this.re.getViewModel();
    }

    public VisualLexicon getVisualLexicon() {
        return this.re.getVisualLexicon();
    }

    public Properties getProperties() {
        return this.re.getProperties();
    }

    public Printable createPrintable() {
        return this.re.createPrintable();
    }

    public <V> Icon createIcon(VisualProperty<V> vp, V value, int width, int height) {
        return this.re.createIcon(vp, value, width, height);
    }

    public void printCanvas(Graphics printCanvas) {
        throw new UnsupportedOperationException("Printing is not supported for Bird's eye view.");
    }

    public void dispose() {
        this.renderComponent.dispose();
        this.contentChangedTimer.shutdown();
        this.re = null;
    }

    public String getRendererId() {
        return "org.cytoscape.ding";
    }

    private final class InnerMouseListener
    extends MouseAdapter {
        private final double[] coords = new double[2];
        private Point mousePressedPoint;
        private DRenderingEngine.Panner panner = null;

        private InnerMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ViewUtil.isSingleLeftClick(e)) {
                return;
            }
            this.mousePressedPoint = e.getPoint();
            double myXCenter = BirdsEyeView.this.renderComponent.getTransform().getCenterX();
            double myYCenter = BirdsEyeView.this.renderComponent.getTransform().getCenterY();
            double myScaleFactor = BirdsEyeView.this.renderComponent.getTransform().getScaleFactor();
            double halfWidth = (double)BirdsEyeView.this.renderComponent.getWidth() / 2.0;
            double halfHeight = (double)BirdsEyeView.this.renderComponent.getHeight() / 2.0;
            double centerX = ((double)e.getX() - halfWidth) / myScaleFactor + myXCenter;
            double centerY = ((double)e.getY() - halfHeight) / myScaleFactor + myYCenter;
            BirdsEyeView.this.re.setCenter(centerX, centerY);
            BirdsEyeView.this.re.updateView(DRenderingEngine.UpdateType.ALL_FULL);
            this.panner = BirdsEyeView.this.re.startPan();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mousePressedPoint != null) {
                this.coords[0] = this.mousePressedPoint.getX();
                this.coords[1] = this.mousePressedPoint.getY();
                BirdsEyeView.this.renderComponent.getTransform().xformImageToNodeCoords(this.coords);
                double oldX = this.coords[0];
                double oldY = this.coords[1];
                this.coords[0] = e.getX();
                this.coords[1] = e.getY();
                BirdsEyeView.this.renderComponent.getTransform().xformImageToNodeCoords(this.coords);
                double newX = this.coords[0];
                double newY = this.coords[1];
                this.mousePressedPoint = e.getPoint();
                double deltaX = oldX - newX;
                double deltaY = oldY - newY;
                this.panner.continuePan(-deltaX, -deltaY);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mousePressedPoint = null;
            if (this.panner != null) {
                this.panner.endPan();
                this.panner = null;
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            BirdsEyeView.this.re.getInputHandlerGlassPane().processMouseWheelEvent(e);
        }
    }
}

