/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.icon;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import org.cytoscape.cg.util.CustomGraphicsIcon;
import org.cytoscape.ding.DArrowShape;
import org.cytoscape.ding.DNodeShape;
import org.cytoscape.ding.icon.ArrowIcon;
import org.cytoscape.ding.icon.ColorIcon;
import org.cytoscape.ding.icon.EdgeBendIcon;
import org.cytoscape.ding.icon.EdgeStackingIcon;
import org.cytoscape.ding.icon.FontFaceIcon;
import org.cytoscape.ding.icon.NodeIcon;
import org.cytoscape.ding.icon.ObjectPositionIcon;
import org.cytoscape.ding.icon.StrokeIcon;
import org.cytoscape.ding.icon.TextIcon;
import org.cytoscape.ding.icon.VisualPropertyIcon;
import org.cytoscape.ding.impl.DLineType;
import org.cytoscape.view.presentation.customgraphics.CyCustomGraphics;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.view.presentation.property.values.EdgeStacking;
import org.cytoscape.view.presentation.property.values.LineType;
import org.cytoscape.view.presentation.property.values.NodeShape;
import org.cytoscape.view.presentation.property.values.ObjectPosition;

public final class VisualPropertyIconFactory {
    public static <V> Icon createIcon(V value, int w, int h) {
        if (value == null) {
            return null;
        }
        VisualPropertyIcon icon = null;
        if (value instanceof Color) {
            icon = new ColorIcon((Color)value, w, h, value.toString());
        } else if (value instanceof NodeShape) {
            DNodeShape dShape = NodeShapeVisualProperty.isDefaultShape((NodeShape)((NodeShape)value)) ? DNodeShape.getDShape((NodeShape)value) : (DNodeShape)value;
            icon = new NodeIcon(dShape.getShape(), w, h, dShape.getDisplayName());
        } else if (value instanceof LineType) {
            icon = new StrokeIcon(DLineType.getDLineType((LineType)value).getStroke(2.0f), w, h, value.toString());
        } else if (value instanceof CyCustomGraphics) {
            String name = ((CyCustomGraphics)value).getDisplayName();
            icon = new CustomGraphicsIcon((CyCustomGraphics)value, w, h, name);
        } else {
            ArrowShape arrowShape;
            DArrowShape dShape;
            icon = value instanceof ObjectPosition ? new ObjectPositionIcon((ObjectPosition)value, w, h, "Label") : (value instanceof Font ? new FontFaceIcon((Font)value, w, h, "") : (value instanceof ArrowShape ? ((dShape = ArrowShapeVisualProperty.isDefaultShape((ArrowShape)(arrowShape = (ArrowShape)value)) ? DArrowShape.getArrowShape(arrowShape) : DArrowShape.NONE).getShape() == null ? new TextIcon(value, w, h, "") : new ArrowIcon(dShape.getShape(), w, h, dShape.getDisplayName())) : (value instanceof Bend ? new EdgeBendIcon((Bend)value, w, h, value.toString()) : (value instanceof EdgeStacking ? new EdgeStackingIcon((EdgeStacking)value, w, h, value.toString()) : new TextIcon(value, w, h, value.toString())))));
        }
        return icon;
    }

    private VisualPropertyIconFactory() {
    }
}

