/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.icon;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import org.cytoscape.ding.icon.VisualPropertyIcon;
import org.cytoscape.view.presentation.property.EdgeStackingVisualProperty;
import org.cytoscape.view.presentation.property.values.EdgeStacking;

public class EdgeStackingIcon
extends VisualPropertyIcon<EdgeStacking> {
    private static final Stroke EDGE_STROKE = new BasicStroke(2.0f, 1, 0);

    public EdgeStackingIcon(EdgeStacking value, int width, int height, String name) {
        super(value, width, height, name);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(c != null ? c.getForeground() : this.color);
        g2d.setStroke(EDGE_STROKE);
        g2d.translate(x, y);
        double x1 = 0.0;
        double x2 = x1 + (double)this.width;
        double xc = (double)this.width / 2.0;
        double ym = (double)this.height / 2.0;
        double vpad = Math.max(1.0, (double)this.height / 6.0);
        if (this.value == EdgeStackingVisualProperty.HAYSTACK) {
            g2d.draw(new Line2D.Double(x1, ym - vpad, x2, ym));
            g2d.draw(new Line2D.Double(x1, ym, x2, ym + 1.5 * vpad));
            g2d.draw(new Line2D.Double(x1, ym + vpad, x2, ym - vpad));
        } else if (this.value == EdgeStackingVisualProperty.AUTO_BEND) {
            g2d.draw(new QuadCurve2D.Double(x1, ym - vpad, xc, 0.0, x2, ym - vpad));
            g2d.draw(new Line2D.Double(x1, ym, x2, ym));
            g2d.draw(new QuadCurve2D.Double(x1, ym + vpad, xc, this.height, x2, ym + vpad));
        }
        g2d.dispose();
    }
}

