/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.lang.constant.Constable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.NetworkImageFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;

public class ThumbnailPanel
extends BasicCollapsiblePanel {
    private final CyServiceRegistrar registrar;

    public ThumbnailPanel(CyServiceRegistrar registrar) {
        super("NetworkImageFactory service");
        this.registrar = registrar;
        this.createContents();
    }

    private void createContents() {
        JLabel heightLabel = new JLabel("Height");
        JSpinner heightSpinner = new JSpinner(new SpinnerNumberModel(200, 0, 1000000, 100));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{heightLabel, heightSpinner});
        JLabel widthLabel = new JLabel("Width");
        JSpinner widthSpinner = new JSpinner(new SpinnerNumberModel(200, 0, 1000000, 100));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{widthLabel, widthSpinner});
        JCheckBox fitContentCheck = new JCheckBox("Fit Content");
        fitContentCheck.setSelected(true);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{fitContentCheck});
        JCheckBox annotationsCheck = new JCheckBox("Include Annotations");
        annotationsCheck.setSelected(true);
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{annotationsCheck});
        JButton createButton = new JButton("Create");
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{createButton});
        createButton.addActionListener(e -> {
            int width = ((SpinnerNumberModel)widthSpinner.getModel()).getNumber().intValue();
            int height = ((SpinnerNumberModel)heightSpinner.getModel()).getNumber().intValue();
            boolean fitContent = fitContentCheck.isSelected();
            boolean includeAnnotations = annotationsCheck.isSelected();
            this.createAndShowThumbnail(width, height, fitContent, includeAnnotations);
        });
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(heightLabel).addComponent(widthLabel)).addGroup(layout.createParallelGroup().addComponent(heightSpinner).addComponent(widthSpinner))).addComponent(fitContentCheck).addComponent(annotationsCheck).addComponent(createButton));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(heightLabel).addComponent(heightSpinner, -2, -2, -2)).addGroup(layout.createParallelGroup().addComponent(widthLabel).addComponent(widthSpinner, -2, -2, -2)).addComponent(fitContentCheck).addComponent(annotationsCheck).addComponent(createButton));
        JPanel content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add("West", panel);
    }

    private void createAndShowThumbnail(int width, int height, boolean fitContent, boolean includeAnnotations) {
        CyApplicationManager applicationManager = (CyApplicationManager)this.registrar.getService(CyApplicationManager.class);
        NetworkImageFactory thumbnailFactory = (NetworkImageFactory)this.registrar.getService(NetworkImageFactory.class, "(id=ding)");
        AnnotationManager annotationManager = (AnnotationManager)this.registrar.getService(AnnotationManager.class);
        CyNetworkView networkView = applicationManager.getCurrentNetworkView();
        if (networkView == null) {
            return;
        }
        HashMap<String, Constable> props = new HashMap<String, Constable>();
        props.put("width", Integer.valueOf(width));
        props.put("height", Integer.valueOf(height));
        props.put("fitContent", Boolean.valueOf(fitContent));
        List annotations = null;
        if (includeAnnotations) {
            annotations = annotationManager.getAnnotations(networkView);
        }
        Image image = thumbnailFactory.createImage(networkView, (Collection)annotations, props);
        JLabel picLabel = new JLabel(new ImageIcon(image));
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), picLabel);
    }
}

