/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cytoscape.ding.debug.DebugProgressMonitor;
import org.cytoscape.ding.impl.work.ProgressMonitor;
import org.cytoscape.ding.impl.work.SubProgressMonitor;

public class DebugSubProgressMonitor
extends SubProgressMonitor
implements DebugProgressMonitor {
    private List<DebugSubProgressMonitor> subMonitors = Collections.emptyList();
    private String taskName;
    private long start;
    private long time = 0L;

    protected DebugSubProgressMonitor(ProgressMonitor parent, double percent) {
        super(parent, percent);
    }

    @Override
    public ProgressMonitor[] split(double ... parts) {
        this.subMonitors = new ArrayList<DebugSubProgressMonitor>(parts.length);
        return DebugProgressMonitor.super.split(parts);
    }

    @Override
    public void start(String taskName) {
        this.taskName = taskName;
        this.start = System.currentTimeMillis();
    }

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void done() {
        super.done();
        long end = System.currentTimeMillis();
        this.time += end - this.start;
        this.start = 0L;
    }

    @Override
    public void emptyTask(String taskName) {
        this.taskName = taskName;
    }

    @Override
    public ProgressMonitor createSubProgressMonitor(double percent) {
        DebugSubProgressMonitor sub = new DebugSubProgressMonitor(this, percent);
        this.subMonitors.add(sub);
        return sub;
    }

    @Override
    public List<DebugSubProgressMonitor> getSubMonitors() {
        return this.subMonitors;
    }

    @Override
    public long getTime() {
        return this.time;
    }
}

