/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.ding.ShowGraphicsDetailsTaskFactory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.swing.DialogTaskManager;

public class GraphicsDetailAction
extends AbstractCyAction {
    private Long lastViewSuid;
    private long lastTime = -1L;
    private ShowGraphicsDetailsTaskFactory taskFactory;
    private final CyServiceRegistrar serviceRegistrar;

    public GraphicsDetailAction(float gravity, String preferredMenu, ShowGraphicsDetailsTaskFactory taskFactory, CyServiceRegistrar serviceRegistrar) {
        super("Always Show Graphics Details", (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), "networkAndView", (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class));
        this.taskFactory = taskFactory;
        this.serviceRegistrar = serviceRegistrar;
        if (preferredMenu != null) {
            this.setPreferredMenu(preferredMenu);
            this.setAcceleratorKeyStroke(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        }
        this.setMenuGravity(gravity);
        this.useCheckBoxMenuItem = true;
    }

    public void actionPerformed(ActionEvent evt) {
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        long currentTime = System.currentTimeMillis();
        if (this.taskFactory.isReady(view)) {
            Object source = evt.getSource();
            if (LookAndFeelUtil.isAquaLAF() && source instanceof JCheckBoxMenuItem && view.getSUID().equals(this.lastViewSuid) && currentTime - this.lastTime < 32L) {
                return;
            }
            if (LookAndFeelUtil.isAquaLAF() && source instanceof JCheckBoxMenuItem) {
                this.lastTime = currentTime;
                this.lastViewSuid = view.getSUID();
            }
            ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(this.taskFactory.createTaskIterator(view));
        }
    }

    public void menuSelected(MenuEvent me) {
        this.updateEnableState();
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        if (view != null && this.isEnabled()) {
            this.putValue("SwingSelectedKey", Boolean.TRUE.equals(view.getVisualProperty(DVisualLexicon.NETWORK_FORCE_HIGH_DETAIL)));
        } else {
            this.putValue("SwingSelectedKey", false);
        }
    }

    public void updateEnableState() {
        CyNetworkView view = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        this.setEnabled(this.taskFactory.isReady(view));
    }
}

