/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.event.ActionEvent;
import javax.swing.event.MenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.ding.DVisualLexicon;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineFactory;

public class SelectModeAction
extends AbstractCyAction {
    public static final String NODES = "Nodes Only";
    public static final String EDGES = "Edges Only";
    public static final String ANNOTATIONS = "Annotations Only";
    public static final String NODES_EDGES = "Nodes and Edges";
    public static final String NODE_LABELS = "Node Labels Only";
    public static final String ALL = "All";
    private final CyServiceRegistrar serviceRegistrar;

    public SelectModeAction(String name, float gravity, CyServiceRegistrar serviceRegistrar) {
        super(name);
        this.serviceRegistrar = serviceRegistrar;
        this.useCheckBoxMenuItem = true;
        this.setPreferredMenu("Select.Mouse Drag Selects[1]");
        this.setMenuGravity(gravity);
    }

    public void actionPerformed(ActionEvent e) {
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView view = applicationManager.getCurrentNetworkView();
        if (view != null) {
            String name = this.name;
            view.batch(nv -> {
                if (name.equalsIgnoreCase(NODES)) {
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_EDGE_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_ANNOTATION_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION, (Object)Boolean.FALSE);
                } else if (name.equalsIgnoreCase(EDGES)) {
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_EDGE_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_ANNOTATION_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION, (Object)Boolean.FALSE);
                } else if (name.equalsIgnoreCase(ANNOTATIONS)) {
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_EDGE_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_ANNOTATION_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION, (Object)Boolean.FALSE);
                } else if (name.equalsIgnoreCase(NODES_EDGES)) {
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_EDGE_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_ANNOTATION_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION, (Object)Boolean.FALSE);
                } else if (name.equalsIgnoreCase(NODE_LABELS)) {
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_EDGE_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_ANNOTATION_SELECTION, (Object)Boolean.FALSE);
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION, (Object)Boolean.TRUE);
                } else if (name.equalsIgnoreCase(ALL)) {
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_EDGE_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_ANNOTATION_SELECTION, (Object)Boolean.TRUE);
                    view.setLockedValue(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION, (Object)Boolean.TRUE);
                }
            }, false);
        }
    }

    public boolean isEnabled() {
        VisualLexicon lexicon;
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView view = applicationManager.getCurrentNetworkView();
        if (view == null) {
            return false;
        }
        NetworkViewRenderer renderer = applicationManager.getNetworkViewRenderer(view.getRendererId());
        RenderingEngineFactory factory = renderer == null ? null : renderer.getRenderingEngineFactory("");
        VisualLexicon visualLexicon = lexicon = factory == null ? null : factory.getVisualLexicon();
        if (lexicon == null) {
            return false;
        }
        VisualProperty vp1 = lexicon.lookup(DVisualLexicon.NETWORK_NODE_SELECTION.getTargetDataType(), DVisualLexicon.NETWORK_NODE_SELECTION.getIdString());
        VisualProperty vp2 = lexicon.lookup(DVisualLexicon.NETWORK_EDGE_SELECTION.getTargetDataType(), DVisualLexicon.NETWORK_EDGE_SELECTION.getIdString());
        return vp1 != null && lexicon.isSupported(vp1) && vp2 != null && lexicon.isSupported(vp2);
    }

    public void menuSelected(MenuEvent e) {
        boolean select = false;
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView view = applicationManager.getCurrentNetworkView();
        if (view != null) {
            Boolean nodeSelection = (Boolean)view.getVisualProperty(DVisualLexicon.NETWORK_NODE_SELECTION);
            Boolean edgeSelection = (Boolean)view.getVisualProperty(DVisualLexicon.NETWORK_EDGE_SELECTION);
            Boolean annotationSelection = (Boolean)view.getVisualProperty(DVisualLexicon.NETWORK_ANNOTATION_SELECTION);
            Boolean nodeLabelSelection = (Boolean)view.getVisualProperty(DVisualLexicon.NETWORK_NODE_LABEL_SELECTION);
            if (nodeSelection.booleanValue() && edgeSelection.booleanValue() && annotationSelection.booleanValue() && nodeLabelSelection.booleanValue()) {
                select = this.name.equalsIgnoreCase(ALL);
            } else if (nodeSelection.booleanValue() && edgeSelection.booleanValue()) {
                select = this.name.equalsIgnoreCase(NODES_EDGES);
            } else if (nodeSelection.booleanValue()) {
                select = this.name.equalsIgnoreCase(NODES);
            } else if (edgeSelection.booleanValue()) {
                select = this.name.equalsIgnoreCase(EDGES);
            } else if (annotationSelection.booleanValue()) {
                select = this.name.equalsIgnoreCase(ANNOTATIONS);
            } else if (nodeLabelSelection.booleanValue()) {
                select = this.name.equalsIgnoreCase(NODE_LABELS);
            }
        }
        this.putValue("SwingSelectedKey", select);
        this.updateEnableState();
    }
}

