/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.cytoscape.ding.ObjectPlacerControl;
import org.cytoscape.ding.ObjectPlacerGraphic;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.vizmap.gui.editor.ValueEditor;

public class ObjectPositionValueEditor
implements ValueEditor<ObjectPosition> {
    private String label = "OBJECT";
    private ObjectPosition oldValue;
    private boolean canceled;
    private JDialog dialog;
    private ObjectPlacerGraphic graphic;
    private ObjectPlacerControl control;
    private boolean initialized;

    private void init(Component parent) {
        Window owner = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        this.dialog = new JDialog(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.setMinimumSize(new Dimension(400, 600));
        this.dialog.setTitle("Position");
        this.dialog.setResizable(false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ObjectPositionValueEditor.this.cancel();
            }
        });
        this.graphic = new ObjectPlacerGraphic(null, true, this.label);
        this.control = new ObjectPlacerControl();
        this.control.addPropertyChangeListener(this.graphic);
        this.graphic.addPropertyChangeListener(this.control);
        JPanel graphicPanel = new JPanel();
        graphicPanel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
        graphicPanel.setLayout(new BorderLayout());
        graphicPanel.add(this.graphic);
        JButton okButton = new JButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPositionValueEditor.this.dialog.dispose();
            }
        });
        okButton.addActionListener(this.control);
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPositionValueEditor.this.cancel();
            }
        });
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)okButton, (JButton)cancelButton);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.dialog.getRootPane(), (Action)okButton.getAction(), (Action)cancelButton.getAction());
        this.dialog.getRootPane().setDefaultButton(okButton);
        GroupLayout layout = new GroupLayout(this.dialog.getContentPane());
        this.dialog.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(graphicPanel).addComponent(this.control).addComponent(buttonPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(graphicPanel).addComponent(this.control).addComponent(buttonPanel));
    }

    public <S extends ObjectPosition> ObjectPosition showEditor(Component parent, S initialValue) {
        ObjectPosition pos;
        if (!this.initialized) {
            this.init(parent);
            this.initialized = true;
        }
        if (initialValue == null) {
            this.oldValue = null;
            pos = new ObjectPosition();
        } else {
            this.oldValue = initialValue;
            pos = new ObjectPosition(initialValue);
        }
        this.control.setPosition(pos);
        this.graphic.setPosition(pos);
        if (parent != null) {
            this.dialog.setLocationRelativeTo(parent);
        } else {
            this.dialog.setLocationByPlatform(true);
        }
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.canceled) {
            this.canceled = false;
            return this.oldValue;
        }
        return this.control.getPosition();
    }

    public Class<ObjectPosition> getValueType() {
        return ObjectPosition.class;
    }

    private void cancel() {
        this.canceled = true;
        this.dialog.dispose();
    }
}

