/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.Shape;
import java.util.Hashtable;
import java.util.Map;
import org.cytoscape.graph.render.immed.GraphGraphics;
import org.cytoscape.view.presentation.property.ArrowShapeVisualProperty;
import org.cytoscape.view.presentation.property.values.ArrowShape;

public enum DArrowShape {
    NONE("None", "NONE", ArrowShapeVisualProperty.NONE),
    DIAMOND("Diamond", "DIAMOND", ArrowShapeVisualProperty.DIAMOND),
    OPEN_DIAMOND("Open Diamond", "OPEN_DIAMOND", ArrowShapeVisualProperty.OPEN_DIAMOND),
    DELTA("Delta", "DELTA", ArrowShapeVisualProperty.DELTA),
    OPEN_DELTA("Open Delta", "OPEN_DELTA", ArrowShapeVisualProperty.OPEN_DELTA),
    CROSS_DELTA("Cross Delta", "CROSS_DELTA", ArrowShapeVisualProperty.CROSS_DELTA),
    CROSS_OPEN_DELTA("Cross Open Delta", "CROSS_OPEN_DELTA", ArrowShapeVisualProperty.CROSS_OPEN_DELTA),
    ARROW("Arrow", "ARROW", ArrowShapeVisualProperty.ARROW),
    T("T", "T", ArrowShapeVisualProperty.T),
    CIRCLE("Circle", "CIRCLE", ArrowShapeVisualProperty.CIRCLE),
    OPEN_CIRCLE("Open Circle", "OPEN_CIRCLE", ArrowShapeVisualProperty.OPEN_CIRCLE),
    HALF_CIRCLE("Half Circle", "HALF_CIRCLE", ArrowShapeVisualProperty.HALF_CIRCLE),
    OPEN_HALF_CIRCLE("Open Half Circle", "OPEN_HALF_CIRCLE", ArrowShapeVisualProperty.OPEN_HALF_CIRCLE),
    SQUARE("Square", "SQUARE", ArrowShapeVisualProperty.SQUARE),
    OPEN_SQUARE("Open Square", "OPEN_SQUARE", ArrowShapeVisualProperty.OPEN_SQUARE),
    HALF_TOP("Half Top", "HALF_TOP", ArrowShapeVisualProperty.HALF_TOP),
    HALF_BOTTOM("Half Top", "HALF_BOTTOM", ArrowShapeVisualProperty.HALF_BOTTOM),
    DELTA_SHORT_1("Delta Short 1", "DELTA_SHORT_1", ArrowShapeVisualProperty.DELTA_SHORT_1),
    DELTA_SHORT_2("Delta Short 2", "DELTA_SHORT_2", ArrowShapeVisualProperty.DELTA_SHORT_2),
    ARROW_SHORT("Arrow Short", "ARROW_SHORT", ArrowShapeVisualProperty.ARROW_SHORT),
    DIAMOND_SHORT_1("Diamond Short 1", "DIAMOND_SHORT_1", ArrowShapeVisualProperty.DIAMOND_SHORT_1),
    DIAMOND_SHORT_2("Diamond Short 2", "DIAMOND_SHORT_2", ArrowShapeVisualProperty.DIAMOND_SHORT_2);

    private final String displayName;
    private final String serializableString;
    private final ArrowShape presentationShape;
    private static final Map<ArrowShape, Shape> ARROW_SHAPES;
    private static final Map<String, DArrowShape> legacyShapes;

    private DArrowShape(String displayName, String serializableString, ArrowShape presentationShape) {
        this.displayName = displayName;
        this.serializableString = serializableString;
        this.presentationShape = presentationShape;
    }

    public ArrowShape getPresentationShape() {
        return this.presentationShape;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Shape getShape() {
        return ARROW_SHAPES.get(this.presentationShape);
    }

    public static DArrowShape parseArrowText(String text) {
        DArrowShape shape;
        block5: {
            shape = null;
            if (text != null) {
                String key = text.trim().toUpperCase();
                try {
                    shape = DArrowShape.valueOf(key);
                }
                catch (IllegalArgumentException e) {
                    shape = legacyShapes.get(key);
                    if (shape != null) break block5;
                    for (DArrowShape val : DArrowShape.values()) {
                        if (!val.displayName.equalsIgnoreCase(text)) continue;
                        shape = val;
                        break;
                    }
                }
            }
        }
        if (shape == null) {
            shape = NONE;
        }
        return shape;
    }

    public static DArrowShape getArrowShape(ArrowShape arrowShape) {
        String serializedString = arrowShape.getSerializableString();
        for (DArrowShape shape : DArrowShape.values()) {
            if (!DArrowShape.easyStringCompart(shape.serializableString, serializedString)) continue;
            return shape;
        }
        return NONE;
    }

    private static boolean easyStringCompart(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        String likeA = a.replace(" ", "").replace("_", "");
        String likeB = b.replace(" ", "").replace("_", "");
        return likeA.equalsIgnoreCase(likeB);
    }

    static {
        legacyShapes = new Hashtable<String, DArrowShape>();
        legacyShapes.put("0", NONE);
        legacyShapes.put("3", DELTA);
        legacyShapes.put("6", ARROW);
        legacyShapes.put("9", DIAMOND);
        legacyShapes.put("12", CIRCLE);
        legacyShapes.put("15", T);
        legacyShapes.put("16", HALF_TOP);
        legacyShapes.put("17", HALF_BOTTOM);
        ARROW_SHAPES = GraphGraphics.getArrowShapes();
    }
}

