/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal.mappings;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.internal.mappings.PassthroughMappingImpl;
import org.cytoscape.view.vizmap.internal.mappings.StringTranslator;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.view.vizmap.mappings.ValueTranslator;

public class PassthroughMappingFactory
implements VisualMappingFunctionFactory {
    private static final Map<Class<?>, ValueTranslator<?, ?>> TRANSLATORS = new HashMap();
    private static final ValueTranslator<Object, String> DEFAULT_TRANSLATOR = new StringTranslator();
    private final CyServiceRegistrar serviceRegistrar;

    public PassthroughMappingFactory(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void addValueTranslator(ValueTranslator<?, ?> translator, Map<?, ?> props) {
        if (translator != null) {
            TRANSLATORS.put(translator.getTranslatedValueType(), translator);
        }
    }

    public void removeValueTranslator(ValueTranslator<?, ?> translator, Map<?, ?> props) {
    }

    public <K, V> VisualMappingFunction<K, V> createVisualMappingFunction(String attributeName, Class<K> attrValueType, VisualProperty<V> vp) {
        ValueTranslator<?, ?> translator = TRANSLATORS.get(vp.getRange().getType());
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        if (translator != null) {
            return new PassthroughMappingImpl<K, V>(attributeName, attrValueType, vp, translator, eventHelper);
        }
        return new PassthroughMappingImpl<Object, String>(attributeName, attrValueType, vp, DEFAULT_TRANSLATOR, eventHelper);
    }

    public String toString() {
        return "Passthrough Mapping";
    }

    public Class<?> getMappingFunctionType() {
        return PassthroughMapping.class;
    }
}

