/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.internal;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedEvent;
import org.cytoscape.view.model.events.TableViewAboutToBeDestroyedListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.events.table.ColumnVisualStyleSetEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableVisualMappingManagerImpl
implements TableVisualMappingManager,
TableViewAboutToBeDestroyedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<View<CyColumn>, VisualStyle> column2VisualStyleMap;
    private final CyServiceRegistrar serviceRegistrar;
    private final Object lock = new Object();

    public TableVisualMappingManagerImpl(VisualStyleFactory factory, CyServiceRegistrar serviceRegistrar) {
        if (serviceRegistrar == null) {
            throw new NullPointerException("'serviceRegistrar' cannot be null");
        }
        this.column2VisualStyleMap = new WeakHashMap<View<CyColumn>, VisualStyle>();
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(TableViewAboutToBeDestroyedEvent e) {
        CyTableView tableView = e.getTableView();
        for (View colView : tableView.getColumnViews()) {
            this.setVisualStyle((View<CyColumn>)colView, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyle getVisualStyle(View<CyColumn> colView) {
        if (colView == null) {
            logger.warn("Attempting to get the visual style for a null column view.");
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.column2VisualStyleMap.get(colView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisualStyle(View<CyColumn> colView, VisualStyle vs) {
        if (colView == null) {
            throw new NullPointerException("Column view is null.");
        }
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            VisualStyle previousStyle;
            changed = vs == null ? this.column2VisualStyleMap.remove(colView) != null : !vs.equals(previousStyle = this.column2VisualStyleMap.put(colView, vs));
        }
        if (changed) {
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            eventHelper.fireEvent((CyEvent)new ColumnVisualStyleSetEvent((TableVisualMappingManager)this, vs, colView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VisualStyle> getAllVisualStyles() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<VisualStyle>(this.column2VisualStyleMap.values());
        }
    }

    public Set<VisualLexicon> getAllVisualLexicon() {
        LinkedHashSet<VisualLexicon> set = new LinkedHashSet<VisualLexicon>();
        CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        for (TableViewRenderer renderer : appManager.getTableViewRendererSet()) {
            VisualLexicon lexicon;
            RenderingEngineFactory factory = renderer.getRenderingEngineFactory("");
            if (factory == null || (lexicon = factory.getVisualLexicon()) == null) continue;
            set.add(lexicon);
        }
        return set;
    }
}

