/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.core.internal.cellrenderer;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import org.cytoscape.view.vizmap.gui.editor.ContinuousMappingEditor;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;

public final class ContinuousMappingCellRenderer
extends DefaultCellRenderer {
    private static final long serialVersionUID = -6734053848878359286L;
    private final ContinuousMappingEditor<?, ?> editor;

    public ContinuousMappingCellRenderer(ContinuousMappingEditor<?, ?> editor) {
        if (editor == null) {
            throw new NullPointerException("Editor object is null.");
        }
        this.editor = editor;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null || !(value instanceof ContinuousMapping)) {
            this.setText("Unknown Mapping");
            return this;
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        int height = table.getRowHeight(row);
        int width = table.getColumnModel().getColumn(column).getWidth();
        ImageIcon icon = this.editor.drawIcon(width, height - 2, false);
        this.setIcon(icon);
        return this;
    }
}

