/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.AbstractNode;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.TreeNode;
import org.cytoscape.equations.internal.interpreter.Instruction;

public class IdentNode
extends AbstractNode {
    private final String attribName;
    private final Object defaultValue;
    private final Class type;

    public IdentNode(int sourceLocation, String attribName, Object defaultValue, Class type) {
        super(sourceLocation);
        if (type == null) {
            throw new IllegalArgumentException("\"type\" must not be null.");
        }
        if (defaultValue != null && defaultValue.getClass() != type) {
            if (type == Integer.class && defaultValue instanceof Double && IdentNode.isConvertableToInt((Double)defaultValue)) {
                defaultValue = ((Double)defaultValue).intValue();
            } else if (type == Long.class && defaultValue instanceof Double && IdentNode.isConvertableToInt((Double)defaultValue)) {
                defaultValue = ((Double)defaultValue).longValue();
            } else {
                throw new IllegalArgumentException("default value is not compatible with attribute type, expected: " + type.getSimpleName());
            }
        }
        this.attribName = attribName;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    private static boolean isConvertableToInt(double d) {
        return d % 1.0 == 0.0;
    }

    public String toString() {
        return "IdentNode: " + this.attribName + (String)(this.defaultValue == null ? "" : " default=" + this.defaultValue);
    }

    public Class getType() {
        return this.type;
    }

    public TreeNode getLeftChild() {
        return null;
    }

    public TreeNode getRightChild() {
        return null;
    }

    public String getAttribName() {
        return this.attribName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        if (this.defaultValue != null) {
            codeStack.push(new CodeAndSourceLocation(this.defaultValue, -1));
        }
        codeStack.push(new CodeAndSourceLocation((Object)this.attribName, -1));
        codeStack.push(new CodeAndSourceLocation((Object)(this.defaultValue == null ? Instruction.AREF : Instruction.AREF2), this.getSourceLocation()));
    }
}

