/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.parse_tree;

import java.util.Stack;
import org.cytoscape.equations.AbstractNode;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.TreeNode;
import org.cytoscape.equations.internal.Token;
import org.cytoscape.equations.internal.interpreter.Instruction;

public class BinOpNode
extends AbstractNode {
    private final Token operator;
    private final TreeNode lhs;
    private final TreeNode rhs;

    public BinOpNode(int sourceLocation, Token operator, TreeNode lhs, TreeNode rhs) {
        super(sourceLocation);
        if (lhs == null) {
            throw new IllegalArgumentException("left operand must not be null.");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("right operand must not be null.");
        }
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public String toString() {
        return "BinOpNode: " + this.operator;
    }

    public Class getType() {
        return this.operator.isComparisonOperator() ? Boolean.class : this.lhs.getType();
    }

    public TreeNode getLeftChild() {
        return this.lhs;
    }

    public TreeNode getRightChild() {
        return this.rhs;
    }

    public Token getOperator() {
        return this.operator;
    }

    public void genCode(Stack<CodeAndSourceLocation> codeStack) {
        this.rhs.genCode(codeStack);
        this.lhs.genCode(codeStack);
        switch (this.operator) {
            case CARET: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FPOW, this.getSourceLocation()));
                break;
            }
            case PLUS: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FADD, this.getSourceLocation()));
                break;
            }
            case MINUS: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FSUB, this.getSourceLocation()));
                break;
            }
            case DIV: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FDIV, this.getSourceLocation()));
                break;
            }
            case MUL: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.FMUL, this.getSourceLocation()));
                break;
            }
            case EQUAL: {
                codeStack.push(new CodeAndSourceLocation((Object)this.determineOpCode(Instruction.BEQLF, Instruction.BEQLS, Instruction.BEQLB), this.getSourceLocation()));
                break;
            }
            case NOT_EQUAL: {
                codeStack.push(new CodeAndSourceLocation((Object)this.determineOpCode(Instruction.BNEQLF, Instruction.BNEQLS, Instruction.BNEQLB), this.getSourceLocation()));
                break;
            }
            case GREATER_THAN: {
                codeStack.push(new CodeAndSourceLocation((Object)this.determineOpCode(Instruction.BGTF, Instruction.BGTS, Instruction.BGTB), this.getSourceLocation()));
                break;
            }
            case LESS_THAN: {
                codeStack.push(new CodeAndSourceLocation((Object)this.determineOpCode(Instruction.BLTF, Instruction.BLTS, Instruction.BLTB), this.getSourceLocation()));
                break;
            }
            case GREATER_OR_EQUAL: {
                codeStack.push(new CodeAndSourceLocation((Object)this.determineOpCode(Instruction.BGTEF, Instruction.BGTES, Instruction.BGTEB), this.getSourceLocation()));
                break;
            }
            case LESS_OR_EQUAL: {
                codeStack.push(new CodeAndSourceLocation((Object)this.determineOpCode(Instruction.BLTEF, Instruction.BLTES, Instruction.BLTEB), this.getSourceLocation()));
                break;
            }
            case AMPERSAND: {
                codeStack.push(new CodeAndSourceLocation((Object)Instruction.SCONCAT, this.getSourceLocation()));
                break;
            }
            default: {
                throw new IllegalStateException(this.getSourceLocation() + ": unknown operator: " + this.operator + ".");
            }
        }
    }

    private Instruction determineOpCode(Instruction floatOpCode, Instruction stringOpCode, Instruction booleanOpCode) {
        Class operandType = this.lhs.getType();
        if (operandType == Double.class) {
            return floatOpCode;
        }
        if (operandType == String.class) {
            return stringOpCode;
        }
        if (booleanOpCode != null && operandType == Boolean.class) {
            return booleanOpCode;
        }
        throw new IllegalStateException(this.lhs.getSourceLocation() + ": invalid LHS operand type for comparison: " + operandType + ".");
    }
}

