/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Text
extends AbstractFunction {
    public Text() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "value", "Any number."), new ArgDescriptor(ArgType.OPT_STRING, "format", "How to format the first argument using the conventions of the Java DecimalFormat class.")});
    }

    public String getName() {
        return "TEXT";
    }

    public String getCategoryName() {
        return "Text";
    }

    public String getFunctionSummary() {
        return "Returns a number formatted as text.";
    }

    public Class<?> getReturnType() {
        return String.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        DecimalFormat decimalFormat;
        Double doubleValue = FunctionUtil.getArgAsDouble((Object)args[0]);
        Number value = doubleValue.isInfinite() || doubleValue.isNaN() ? doubleValue : new BigDecimal(doubleValue.toString());
        if (args.length == 1) {
            return ((Object)value).toString();
        }
        String format = FunctionUtil.getArgAsString((Object)args[1]);
        if (!this.isValidFormat(format)) {
            throw new IllegalArgumentException("\"" + format + "\" is not a valid format string for the TEXT() function.");
        }
        try {
            decimalFormat = new DecimalFormat(format, new DecimalFormatSymbols(Locale.US));
        }
        catch (Exception e) {
            throw new IllegalStateException("we should *never* get here.");
        }
        try {
            return decimalFormat.format(value).toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("we should *never* get here (2): " + e);
        }
    }

    private boolean isValidFormat(String format) {
        try {
            new DecimalFormat(format);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

