/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Tan
extends AbstractFunction {
    public Tan() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "number", "Any real number representing an angle in radians.")});
    }

    public String getName() {
        return "TAN";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the tanget of an angle given in radians.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double angleInRadians = FunctionUtil.getArgAsDouble((Object)args[0]);
        double cos = Math.cos(angleInRadians);
        if (cos == 0.0) {
            throw new IllegalArgumentException("division by zero in call to TAN().");
        }
        return Math.sin(angleInRadians) / cos;
    }
}

