/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import java.util.List;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Nth
extends AbstractFunction {
    public Nth() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.STRICT_ANY_LIST, "list", "A list of objects."), new ArgDescriptor(ArgType.INT, "index", "An index into the list. The index of the first element is 1.")});
    }

    public String getName() {
        return "NTH";
    }

    public String getCategoryName() {
        return "List";
    }

    public String getFunctionSummary() {
        return "Returns the n-th entry in a list.";
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        int index;
        List list = (List)args[0];
        try {
            index = (int)FunctionUtil.getArgAsLong((Object)args[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[1] + "\" to an integer in a call to NTH().");
        }
        if (index <= 0 || index > list.size()) {
            throw new IllegalArgumentException("illegal list index in call to NTH().");
        }
        Object listElement = list.get(index - 1);
        Object retVal = FunctionUtil.translateObjectType(listElement);
        if (retVal == null) {
            throw new IllegalArgumentException("bad list element type: " + listElement.getClass() + " in a call to NTH().");
        }
        return retVal;
    }
}

