/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Not
extends AbstractFunction {
    public Not() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.BOOL, "truth_value", "Any boolean value.")});
    }

    public String getName() {
        return "NOT";
    }

    public String getCategoryName() {
        return "Logic";
    }

    public String getFunctionSummary() {
        return "Returns the logical negation of a boolean value.";
    }

    public Class<?> getReturnType() {
        return Boolean.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        boolean b;
        try {
            b = FunctionUtil.getArgAsBoolean((Object)args[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert \"" + args[0] + "\" to a boolean value in a call to NOT().");
        }
        return !b;
    }
}

