/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.internal.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class Min
extends AbstractFunction {
    public Min() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOATS, "numbers", "Any combination of lists of numbers or individual numbers.")});
    }

    public String getName() {
        return "MIN";
    }

    public String getCategoryName() {
        return "Numeric";
    }

    public String getFunctionSummary() {
        return "Returns the minimum of a group of numbers.";
    }

    public Class<?> getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        double[] numbers;
        try {
            numbers = FunctionUtil.getDoubles((Object[])args);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't convert an argument or a list element to a number in a call to MIN().");
        }
        double min = Double.POSITIVE_INFINITY;
        for (double d : numbers) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }
}

